/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.bpmn2.BusinessRuleTaskHandler;
import org.jbpm.process.workitem.bpmn2.objects.Person;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.event.kiebase.AfterRuleAddedEvent;
import org.kie.api.event.kiebase.DefaultKieBaseEventListener;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieMavenRepository;

public class BusinessRuleTaskHandlerTest {
    private static final String GROUP_ID = "org.jbpm";
    private static final String ARTIFACT_ID = "test-kjar";
    private static final String VERSION = "1.0-SNAPSHOT";
    private KieServices ks = KieServices.Factory.get();

    @Before
    public void setup() throws Exception {
        this.createAndDeployJar(this.ks, this.ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), this.ks.getResources().newClassPathResource("businessRule.drl"), this.ks.getResources().newClassPathResource("0020-vacation-days.dmn"));
    }

    @Test
    public void testDrlStatefulBusinessRuleTaskNoScanner() {
        TestWorkItemManager manager = new TestWorkItemManager();
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(999L);
        Person person = new Person("john");
        workItem.setParameter("person", (Object)person);
        workItem.setParameter("KieSessionType", (Object)"statefull");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)35L, (long)((Person)results.get("person")).getAge().intValue());
    }

    @Test
    public void testDrlStatelessBusinessRuleTaskNoScanner() {
        TestWorkItemManager manager = new TestWorkItemManager();
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(999L);
        Person person = new Person("john");
        workItem.setParameter("person", (Object)person);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)35L, (long)((Person)results.get("person")).getAge().intValue());
    }

    @Test
    public void testDmnBusinessRuleTaskNoScanner() {
        TestWorkItemManager manager = new TestWorkItemManager();
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(999L);
        workItem.setParameter("Language", (Object)"DMN");
        workItem.setParameter("Namespace", (Object)"https://www.drools.org/kie-dmn");
        workItem.setParameter("Model", (Object)"0020-vacation-days");
        workItem.setParameter("Age", (Object)16);
        workItem.setParameter("Years of Service", (Object)1);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)7L, (long)results.size());
        Assert.assertEquals((long)27L, (long)((BigDecimal)results.get("Total Vacation Days")).intValue());
    }

    @Ignore(value="ignored as it is unstable on jenkins for unknown reason")
    @Test
    public void testDrlStatefulBusinessRuleTaskWithScanner() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION, 2000L);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(999L);
        Person person = new Person("john");
        workItem.setParameter("person", (Object)person);
        workItem.setParameter("KieSessionType", (Object)"statefull");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)35L, (long)((Person)results.get("person")).getAge().intValue());
        this.createAndDeployJar(this.ks, this.ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), this.ks.getResources().newClassPathResource("businessRule2.drl"));
        final CountDownLatch latch = new CountDownLatch(1);
        handler.getKieContainer().getKieBase().addEventListener((KieBaseEventListener)new DefaultKieBaseEventListener(){

            public void afterRuleAdded(AfterRuleAddedEvent event) {
                latch.countDown();
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        person = new Person("john");
        workItem.setParameter("person", (Object)person);
        workItem.setParameter("KieSessionType", (Object)"statefull");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)45L, (long)((Person)results.get("person")).getAge().intValue());
    }

    protected byte[] createAndDeployJar(KieServices ks, ReleaseId releaseId, Resource ... resources) throws Exception {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId);
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        ((InternalKieBuilder)kieBuilder).buildAll(o -> true);
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException(results.getMessages(new Message.Level[]{Message.Level.ERROR}).toString());
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] pomXmlContent = IOUtils.toByteArray((InputStream)kieModule.getPomAsStream());
        File pom = new File("target", UUID.randomUUID().toString());
        Files.write(pom.toPath(), pomXmlContent, new OpenOption[0]);
        KieMavenRepository.getKieMavenRepository().installArtifact((AFReleaseId)releaseId, kieModule, pom);
        byte[] jar = kieModule.getBytes();
        return jar;
    }
}

