/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.codehaus.stax2.XMLStreamWriter2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawXMLStreamWriter
extends DelegatingXMLStreamWriter {
    private static Logger logger = LoggerFactory.getLogger(RawXMLStreamWriter.class);
    private final Collection<String> rawElements;
    private String currentElementName;

    public RawXMLStreamWriter(XMLStreamWriter del, Collection<String> rawElements) {
        super(del);
        this.rawElements = rawElements;
    }

    public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
        this.currentElementName = local;
        super.writeStartElement(prefix, local, uri);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        if (this.delegate instanceof XMLStreamWriter2 && this.rawElements.contains(this.currentElementName)) {
            logger.debug("Writing Raw for element {}", (Object)this.currentElementName);
            ((XMLStreamWriter2)this.delegate).writeRaw(text, start, len);
        } else {
            logger.debug("No Raw replacement for element {} for writer {}", (Object)this.currentElementName, (Object)this.delegate);
            super.writeCharacters(text, start, len);
        }
    }
}

