/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.handler;

import java.util.Map;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.spi.ProcessContext;
import org.jbpm.process.workitem.handler.JavaHandler;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;

public class JavaHandlerWorkItemHandler
implements WorkItemHandler {
    private StatefulKnowledgeSession ksession;

    public JavaHandlerWorkItemHandler(StatefulKnowledgeSession ksession) {
        this.ksession = ksession;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String className = (String)workItem.getParameter("Class");
        try {
            Class<?> c = Class.forName(className);
            JavaHandler handler = (JavaHandler)c.newInstance();
            ProcessContext kcontext = new ProcessContext((KnowledgeRuntime)this.ksession);
            WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.getProcessInstance(workItem.getProcessInstanceId());
            kcontext.setProcessInstance((ProcessInstance)processInstance);
            WorkItemNodeInstance nodeInstance = this.findNodeInstance(workItem.getId(), (NodeInstanceContainer)processInstance);
            kcontext.setNodeInstance((NodeInstance)nodeInstance);
            Map<String, Object> results = handler.execute((org.drools.runtime.process.ProcessContext)kcontext);
            manager.completeWorkItem(workItem.getId(), results);
            return;
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
        catch (InstantiationException e) {
            System.err.println(e);
        }
        catch (IllegalAccessException e) {
            System.err.println(e);
        }
        manager.abortWorkItem(workItem.getId());
    }

    private WorkItemNodeInstance findNodeInstance(long workItemId, NodeInstanceContainer container) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            WorkItemNodeInstance result;
            WorkItemNodeInstance workItemNodeInstance;
            if (nodeInstance instanceof WorkItemNodeInstance && (workItemNodeInstance = (WorkItemNodeInstance)nodeInstance).getWorkItem().getId() == workItemId) {
                return workItemNodeInstance;
            }
            if (!(nodeInstance instanceof NodeInstanceContainer) || (result = this.findNodeInstance(workItemId, (NodeInstanceContainer)nodeInstance)) == null) continue;
            return result;
        }
        return null;
    }

    public void abortWorkItem(WorkItem arg0, WorkItemManager arg1) {
    }
}

