/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes.mapper;

import java.util.function.BiFunction;
import org.dashbuilder.dataset.DataSet;
import org.jbpm.xes.dataset.DataSetUtils;
import org.jbpm.xes.mapper.ProcessInstanceStatusMapper;
import org.jbpm.xes.model.TraceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceTypeMapper
implements BiFunction<DataSet, Integer, TraceType> {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_PROCESS_INSTANCE_ID = "processInstanceId";
    public static final String COLUMN_PROCESS_ID = "processId";
    public static final String COLUMN_USER_IDENTITY = "user_identity";
    public static final String COLUMN_CORRELATION_KEY = "correlationKey";
    public static final String COLUMN_PROCESS_VERSION = "processVersion";
    public static final String COLUMN_PROCESS_INSTANCE_DESCRIPTION = "processInstanceDescription";
    public static final String COLUMN_PARENT_PROCESS_INSTANCE_ID = "parentProcessInstanceId";
    public static final String COLUMN_START_DATE = "start_date";
    public static final String COLUMN_END_DATE = "end_date";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_SLA_DUE_DATE = "sla_due_date";
    public static final String COLUMN_SLA_COMPLIANCE = "slaCompliance";
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceTypeMapper.class);

    @Override
    public TraceType apply(DataSet dataSet, Integer row) {
        Long processInstanceId = DataSetUtils.getColumnLongValue(dataSet, COLUMN_PROCESS_INSTANCE_ID, row);
        TraceType trace = new TraceType();
        trace.addStringType("concept:name", processInstanceId.toString());
        trace.addStringType("jbpm:initiator", DataSetUtils.getColumnStringValue(dataSet, COLUMN_USER_IDENTITY, row));
        trace.addIntegerType("jbpm:logid", DataSetUtils.getColumnLongValue(dataSet, COLUMN_ID, row));
        trace.addStringType("jbpm:correlationkey", DataSetUtils.getColumnStringValue(dataSet, COLUMN_CORRELATION_KEY, row));
        trace.addStringType("jbpm:version", DataSetUtils.getColumnStringValue(dataSet, COLUMN_PROCESS_VERSION, row));
        trace.addStringType("jbpm:description", DataSetUtils.getColumnStringValue(dataSet, COLUMN_PROCESS_INSTANCE_DESCRIPTION, row));
        trace.addIntegerType("jbpm:instanceid", processInstanceId);
        Long parent = DataSetUtils.getColumnLongValue(dataSet, COLUMN_PARENT_PROCESS_INSTANCE_ID, row);
        if (parent != -1L) {
            trace.addIntegerType("jbpm:parentinstanceid", parent);
        }
        trace.addDateType("jbpm:start", DataSetUtils.getColumnDateValue(dataSet, COLUMN_START_DATE, row));
        trace.addDateType("jbpm:end", DataSetUtils.getColumnDateValue(dataSet, COLUMN_END_DATE, row));
        trace.addStringType("jbpm:status", new ProcessInstanceStatusMapper().apply(DataSetUtils.getColumnIntValue(dataSet, COLUMN_STATUS, row)));
        trace.addDateType("jbpm:sladuedate", DataSetUtils.getColumnDateValue(dataSet, COLUMN_SLA_DUE_DATE, row));
        trace.addIntegerType("jbpm:slacompliance", DataSetUtils.getColumnIntValue(dataSet, COLUMN_SLA_COMPLIANCE, row));
        LOGGER.debug("Generated trace object: {}", (Object)trace);
        return trace;
    }
}

