/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes.mapper;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.xes.XESProcessFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilterMapper
implements Function<XESProcessFilter, List<ColumnFilter>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnFilterMapper.class);

    @Override
    public List<ColumnFilter> apply(XESProcessFilter filter) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        if (!Strings.isNullOrEmpty((String)filter.getProcessId())) {
            filters.add(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)filter.getProcessId())));
        }
        if (!Strings.isNullOrEmpty((String)filter.getProcessVersion())) {
            filters.add(FilterFactory.equalsTo((String)"processVersion", (Comparable)((Object)filter.getProcessVersion())));
        }
        if (filter.getStatus() != null && !filter.getStatus().isEmpty()) {
            filters.add(FilterFactory.in((String)"status", filter.getStatus()));
        }
        if (filter.getSince() != null) {
            filters.add(FilterFactory.greaterOrEqualsTo((String)"start_date", (Comparable)filter.getSince()));
        }
        if (filter.getTo() != null) {
            filters.add(FilterFactory.lowerOrEqualsTo((String)"end_date", (Comparable)filter.getTo()));
        }
        LOGGER.debug("Traces column filters: {}", filters);
        return filters;
    }
}

