/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jbpm.xes.model.LogType;
import org.jbpm.xes.model.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XESLogMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(XESLogMarshaller.class);
    private JAXBContext context;

    public XESLogMarshaller() {
        try {
            this.context = JAXBContext.newInstance((String)"org.jbpm.xes.model");
        }
        catch (JAXBException ex) {
            LOGGER.error("Error trying to create XES marshaller: {}", (Object)ex.getMessage(), (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    public String marshall(LogType log) throws Exception {
        Marshaller m = this.context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectFactory factory = new ObjectFactory();
        m.marshal(factory.createLog(log), (OutputStream)stream);
        String xml = stream.toString();
        LOGGER.debug("\n" + xml);
        return xml;
    }

    public LogType unmarshall(String xml) throws Exception {
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        JAXBElement log = (JAXBElement)unmarshaller.unmarshal((Reader)new StringReader(xml));
        return (LogType)log.getValue();
    }
}

