/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model.forms;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class FieldDef
{
   public enum DataType {STRING, LONG, DOUBLE, DATE, BOOL};
   public enum InputType {TEXT, TEXTAREA, CHOICE, SELECT, BOOL};

   private String label;
   private String varname;
   private boolean required;

   private InputType inputType;
   private String dataTypeClass;

   private String description;

   private List defaults = new ArrayList();

   public FieldDef(String label, String varname, InputType inputType, String dataType, boolean required)
   {
      this.label = label;
      this.varname = varname;
      this.inputType = inputType;
      this.dataTypeClass = dataType;
      this.required = required;
   }

   public String getVarname()
   {
      return varname;
   }

   public boolean isRequired()
   {
      return required;
   }

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public InputType getInputType()
   {
      return inputType;
   }

   public String getDataType()
   {
      return dataTypeClass;
   }

   public List getDefaults()
   {
      return defaults;
   }


   public String getLabel()
   {
      return label;
   }
}
