/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.dao;

import org.jboss.bpm.console.server.dao.DiagramDAO;

import javax.servlet.ServletContext;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public abstract class DAOFactory
{
   public abstract ProcessDAO createProcessDAO();

   public abstract DiagramDAO createDiagramDAO();

   public abstract TaskDAO createTaskDAO();

   /**
    * Expects an init parameter <code>org.jboss.bpm.console.server.dao.DAOFactory</code>
    * refering to the implementation class name that should be created.
    * @param context ServletContext
    * @return a DAOFactory implementation
    */
   public static DAOFactory newInstance(ServletContext context)
   {
      String daoFactoryClassName = context.getInitParameter(DAOFactory.class.getName());
      if(null==daoFactoryClassName)
         throw new RuntimeException("Failed to load DAOFactory. Init parameter " +
           DAOFactory.class.getName() + " is missing");

      try
      {
         return (DAOFactory)Class.forName(daoFactoryClassName).newInstance();
      }
      catch (Exception e)
      {
         throw new RuntimeException("Failed to load DAOFactory", e);
      }
   }
}
