/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.dao.internal;

import org.jboss.bpm.console.client.model.jbpm3.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.jbpm3.DiagramInfo;
import org.jboss.bpm.console.client.model.jbpm3.DiagramNodeInfo;
import org.jboss.bpm.console.server.dao.DiagramDAO;

import java.io.InputStream;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class JBPM3DiagramDAO implements DiagramDAO
{
   private JBPM3CommandDelegate delegate;

   private static final String PROCESSIMAGE_FILENAME = "processimage.jpg";
   private static final String GPD_XML_FILENAME = "gpd.xml";

   public JBPM3DiagramDAO()
   {
      this.delegate = new JBPM3CommandDelegate();
   }

   public byte[] getProcessImage(long processId)
   {
      org.jbpm.graph.def.ProcessDefinition p0 = delegate.getActualDefinition(processId);
      return p0.getFileDefinition().getBytes(PROCESSIMAGE_FILENAME);
   }

   public DiagramInfo getDiagramInfo(long processId)
   {
      org.jbpm.graph.def.ProcessDefinition p0 = delegate.getActualDefinition(processId);
      InputStream in = p0.getFileDefinition().getInputStream(GPD_XML_FILENAME);
      return DiagramInfoParser.parse(in);
   }

   public ActiveNodeInfo getActivNodeInfo(long instanceId)
   {
      org.jbpm.graph.exe.ProcessInstance instance = delegate.getActualInstance(instanceId);
      String currentNodeName = instance.getRootToken().getNode().getName();
      
      DiagramInfo diagram = getDiagramInfo(instance.getProcessDefinition().getId());
      List<DiagramNodeInfo> nodes = diagram.getNodeList();

      DiagramNodeInfo activeNode = null;
      int i = 0;
      for(DiagramNodeInfo n : nodes)
      {
         if(currentNodeName.equals(n.getName()))
         {
            activeNode = n;
            break;
         }
      }

      if(null==activeNode)
         throw new RuntimeException("Failed to retrieve activeNodeInfo for instance " + instanceId);

      return new ActiveNodeInfo(diagram.getWidth(), diagram.getHeight(), activeNode);
   }
}
