/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.dao.internal;

import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.model.TaskReference;
import org.jboss.bpm.console.server.dao.ProcessDAO;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MockProcessDAO implements ProcessDAO
{

   final static List<ProcessDefinition> defs = new ArrayList<ProcessDefinition>();
   static
   {
      defs.add( new ProcessDefinition(1, "OrderProcess", "1"));
      defs.add( new ProcessDefinition(2, "VacationManagement", "1"));
      defs.add( new ProcessDefinition(3, "New Employee walkthrough", "1"));
      defs.add( new ProcessDefinition(4, "Source code review", "2"));
      defs.add( new ProcessDefinition(5, "Loan application", "1"));
      defs.add( new ProcessDefinition(6, "Expense report review", "4"));
      defs.add( new ProcessDefinition(7, "Expense claim", "4"));
      defs.add( new ProcessDefinition(8, "Credit approval", "4"));
   }

   final static List<ProcessInstance> instances = new ArrayList<ProcessInstance>();
   static
   {
      instances.add( new ProcessInstance(2, -1, new Date(), null, false));
      instances.add( new ProcessInstance(3, -1, new Date(System.currentTimeMillis()-(1000*60*120)), new Date(System.currentTimeMillis()-(1000*60*12)), false));
      instances.add( new ProcessInstance(4, -1, new Date(System.currentTimeMillis()-(1000*60*60)), new Date(System.currentTimeMillis()-(1000*60*24)), false));
      instances.add( new ProcessInstance(5, -1, new Date(System.currentTimeMillis()-(1000*60*90)), new Date(System.currentTimeMillis()-(1000*60*17)), false));
      instances.add( new ProcessInstance(6, -1, new Date(), null, true));
      instances.add( new ProcessInstance(7, -1, new Date(), null, true));
   }

   public List<ProcessDefinition> getAllDefinitions()
   {
      return defs;
   }

   public ProcessDefinition getDefinitionById(long id)
   {
      ProcessDefinition match = null;
      for(ProcessDefinition pd : defs)
      {
         if(pd.getProcessId() == id)
         {
            match = pd;
            break;
         }
      }
      return match;
   }


   public List<ProcessDefinition> removeDefinition(long processId)
   {
      System.out.println("Remove definition " + processId);

      ProcessDefinition toBeRemoved = null;
      for(ProcessDefinition pd : defs)
      {
         if(processId == pd.getProcessId())
            toBeRemoved = pd;
      }

      if(null==toBeRemoved)
         throw new IllegalArgumentException("No process with id " + processId);
      else
         defs.remove(toBeRemoved);

      return defs;
   }

   public List<ProcessInstance> getInstancesByProcessId(long id)
   {
      return instances;
   }


   public void changeState(long instanceId, String nextState)
   {

      System.out.println("Change instance state" + instanceId + " to " + nextState);

      ProcessInstance toBeChanged = null;
      for(ProcessInstance instance : instances)
      {
         if(instanceId == instance.getInstanceId())
            toBeChanged = instance;
      }

      if(null==toBeChanged)
         throw new IllegalArgumentException("No process with id " + instanceId);
      
      toBeChanged.setState(nextState);
   }

   public ProcessInstance getInstanceById(long instanceId)
   {
      ProcessInstance match = null;
      for(ProcessInstance instance : instances)
      {
         if(instanceId == instance.getInstanceId())
            match = instance;
      }

      if(null==match)
         throw new IllegalArgumentException("No instance with id " + instanceId);

      return match;
   }


   public ProcessInstance newInstance(long processId)
   {
      throw new RuntimeException("Not implemented");
   }


   public ProcessDefinition deployNewDefinition(byte[] data)
   {
      throw new RuntimeException("Not implemented");
   }


   public List<TaskReference> getAllTasks()
   {
      throw new RuntimeException("Not implemented");
   }
}
