/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.dao.internal;

import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.model.TaskReference;
import org.jbpm.graph.def.Transition;

import java.util.Date;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Transform
{
   public static ProcessDefinition processDefinition(org.jbpm.graph.def.ProcessDefinition p0)
   {
      return new ProcessDefinition(p0.getId(), p0.getName(), String.valueOf(p0.getVersion()));
   }

   public static ProcessInstance processInstance(org.jbpm.graph.exe.ProcessInstance i0)
   {      
      Date start = i0.getStart();      
      Date end = i0.getEnd();
      boolean suspended = i0.isSuspended();
      long processId = i0.getProcessDefinition().getId();
      long instanceId = i0.getId();
      return new ProcessInstance(instanceId, processId, start, end, suspended);
   }

   public static void doTransition(org.jbpm.graph.exe.ProcessInstance p0, String nextState)
   {
      ProcessInstance instance = Transform.processInstance(p0);
      instance.setState(nextState);  // has lifecycle build in, hence the extra round

      switch(instance.getState())
      {
         case ENDED:
            p0.setEnd(instance.getEndDate());
            p0.end();
            break;
         case SUSPENDED:
            p0.suspend();
            break;
         case RUNNING:
            if(p0.isSuspended())
               p0.resume();            
      }
            
   }

   public static TaskReference taskInstance(org.jbpm.taskmgmt.exe.TaskInstance t0)
   {
      TaskReference taskRef = new TaskReference(
            t0.getId(),
            t0.getToken().getId(),
            t0.getProcessInstance().getId(),
            t0.getProcessInstance().getProcessDefinition().getId(),
            t0.getName(), t0.getActorId(),
            t0.isBlocking(), t0.isSignalling()            
      );

      List<Transition> transitionList =  (List<Transition>)
            t0.getToken().getNode().getLeavingTransitionsList();

      for(Transition trs0 : transitionList)
      {
         taskRef.getTransitionNames().add(
               trs0.getName()
         );
      }

      return taskRef;
   }


}
