/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.dao.internal;

import org.jboss.bpm.console.client.model.ProcessDefinition;
import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.model.TaskReference;
import org.jboss.bpm.console.server.dao.ProcessDAO;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class JBPM3ProcessDAO implements ProcessDAO
{
   private JBPM3CommandDelegate delegate;

   public JBPM3ProcessDAO()
   {
      this.delegate = new JBPM3CommandDelegate();
   }

   public List<ProcessDefinition> getAllDefinitions()
   {
      List<org.jbpm.graph.def.ProcessDefinition> defs = delegate.getActualDefinitions();

      List<ProcessDefinition> results = new ArrayList<ProcessDefinition>(defs.size());
      for(org.jbpm.graph.def.ProcessDefinition p0 : defs)
      {
         results.add( Transform.processDefinition(p0) );
      }
      return results;
   }

   public ProcessDefinition getDefinitionById(long processId)
   {
      org.jbpm.graph.def.ProcessDefinition p0 = delegate.getActualDefinition(processId);
      return Transform.processDefinition(p0);
   }

   public List<ProcessDefinition> removeDefinition(long processId)
   {
      delegate.removeActualDefinition(processId);
      return getAllDefinitions();
   }


   public ProcessInstance newInstance(long processId)
   {
      org.jbpm.graph.exe.ProcessInstance instance = delegate.startNewInstance(processId);
      return Transform.processInstance(instance);  
   }

   public List<ProcessInstance> getInstancesByProcessId(long processId)
   {
      List<org.jbpm.graph.exe.ProcessInstance> instances = delegate.getActualInstances(processId);
      List<ProcessInstance> results = new ArrayList<ProcessInstance>(instances.size());
      for(org.jbpm.graph.exe.ProcessInstance i0 : instances)
      {
         results.add( Transform.processInstance(i0) );
      }
      return results;
   }

   public ProcessInstance getInstanceById(long instanceId)
   {
      org.jbpm.graph.exe.ProcessInstance instance = delegate.getActualInstance(instanceId);
      return Transform.processInstance(instance);
   }


   public void changeState(long instanceId, String nextState)
   {
      org.jbpm.graph.exe.ProcessInstance p0 = delegate.getActualInstance(instanceId);
      Transform.doTransition(p0, nextState);  // modifies the actual PI

      // TX commit will persist changes to the actual PI

      
   }

   public ProcessDefinition deployNewDefinition(byte[] data)
   {
      org.jbpm.graph.def.ProcessDefinition p0 = delegate.deploy(data);
      return Transform.processDefinition(p0);  
   }


   public List<TaskReference> getAllTasks()
   {
      return null;  //To change body of implemented methods use File | Settings | File Templates.
   }
}
