/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.dao.internal;

import org.jboss.bpm.console.client.model.ProcessInstance;
import org.jboss.bpm.console.client.model.jbpm3.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.jbpm3.DiagramInfo;
import org.jboss.bpm.console.client.model.jbpm3.DiagramNodeInfo;
import org.jboss.bpm.console.server.dao.ProcessDAO;
import org.jboss.bpm.console.server.dao.DiagramDAO;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MockDiagramDAO extends MockProcessDAO implements DiagramDAO
{

   public MockDiagramDAO()
   {
      super();
   }

   public byte[] getProcessImage(long processId)
   {
      byte[] imageBytes = null;

      try
      {
         InputStream in = MockDiagramDAO.class.getResourceAsStream("1.jpg");
         if(null==in)
            throw new IllegalArgumentException("Failed to load image resource");
         imageBytes = new byte[in.available()];
         in.read(imageBytes);

      } catch (IOException e)
      {
         e.printStackTrace();
      }

      return imageBytes;
   }

   public DiagramInfo getDiagramInfo(long processId)
   {
      InputStream in = MockDiagramDAO.class.getResourceAsStream("gpd.xml");
      if(null==in)
         throw new IllegalArgumentException("Failed to load diagram info");

      return DiagramInfoParser.parse(in);
   }

   public ActiveNodeInfo getActivNodeInfo(long instanceId)
   {

      ProcessInstance pi = super.getInstanceById(instanceId);
      DiagramInfo diagram = getDiagramInfo(pi.getParentId());
      List<DiagramNodeInfo> nodes = diagram.getNodeList();

      DiagramNodeInfo activeNode = null;
      int i = 0;
      for(DiagramNodeInfo n : nodes)
      {
         // TODO: Fake. Actually this should retrieve the active node
         if(i==1)
         {
            activeNode = n;
            break;
         }

         i++;

      }

      if(null==activeNode)
         throw new RuntimeException("Failed to retrieve active node for instanceId " + instanceId);
      
      return new ActiveNodeInfo(diagram.getWidth(), diagram.getHeight(), activeNode);
   }
}
