/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.integration.jbpm3;

import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.command.Command;
import org.jbpm.identity.Group;
import org.jbpm.identity.User;
import org.jbpm.identity.hibernate.IdentitySession;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * TODO: Group resolution should be pluggable
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class GetUsersForGroupCommand extends AbstractGetObjectBaseCommand implements Command
{
   private static final long serialVersionUID = -1627380259541998349L;

   private String groupName;

   public GetUsersForGroupCommand(String groupName)
   {
      super();
      this.groupName = groupName;
   }

   public Object execute(JbpmContext jbpmContext) throws Exception
   {
      List<String> userNames = new ArrayList<String>();

      setJbpmContext(jbpmContext);

      IdentitySession session = new IdentitySession(
            jbpmContext.getSession()
      );

      Group group = session.getGroupByName(groupName);
      Set<User> users = group.getUsers();
      for(User u : users)
      {
         userNames.add(u.getName());
      }

      return userNames;
   }
}
