/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextInputField
extends JComponent
implements ProcessingClient {
    private static final long serialVersionUID = 8611515659787697087L;
    private Map<String, String> validatorParams;
    private Validator validationService;
    private JTextField field;
    private boolean hasParams = false;

    public TextInputField(String string, int n, String string2, Map<String, String> map) {
        this(string, n, string2);
        this.validatorParams = map;
        this.hasParams = true;
    }

    public TextInputField(String string, int n, String string2) {
        try {
            if (string2 != null) {
                Debug.trace("Making Validator for: " + string2);
                this.validationService = (Validator)Class.forName(string2).newInstance();
            }
        }
        catch (Throwable throwable) {
            this.validationService = null;
            Debug.trace(throwable);
        }
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(3);
        flowLayout.setVgap(0);
        this.setLayout(flowLayout);
        this.field = new JTextField(string, n);
        this.field.setCaretPosition(0);
        this.add(this.field);
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.validatorParams;
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    public void setText(String string) {
        this.field.setText(string);
    }

    @Override
    public String getFieldContents(int n) {
        return this.field.getText();
    }

    @Override
    public int getNumFields() {
        return 1;
    }

    public boolean validateContents() {
        if (this.validationService != null) {
            Debug.trace("Validating contents");
            return this.validationService.validate(this);
        }
        Debug.trace("Not validating contents");
        return true;
    }

    @Override
    public boolean hasParams() {
        return this.hasParams;
    }
}

