/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.AndCondition;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.JavaCondition;
import com.izforge.izpack.rules.NotCondition;
import com.izforge.izpack.rules.OrCondition;
import com.izforge.izpack.rules.PackselectionCondition;
import com.izforge.izpack.rules.XorCondition;
import com.izforge.izpack.util.Debug;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class RulesEngine {
    protected Map<String, String> panelconditions;
    protected Map<String, String> packconditions;
    protected Map<String, String> optionalpackconditions;
    protected XMLElement conditionsspec;
    protected static Map conditionsmap = new HashMap();
    protected static AutomatedInstallData installdata;

    private static void loadStaticConditions() {
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS", "izpack.windowsinstall");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_XP", "izpack.windowsinstall.xp");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_2003", "izpack.windowsinstall.2003");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_VISTA", "izpack.windowsinstall.vista");
        RulesEngine.createBuiltinOsCondition("IS_WINDOWS_7", "izpack.windowsinstall.7");
        RulesEngine.createBuiltinOsCondition("IS_LINUX", "izpack.linuxinstall");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        RulesEngine.createBuiltinOsCondition("IS_MAC", "izpack.macinstall");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS_X86", "izpack.solarisinstall.x86");
        RulesEngine.createBuiltinOsCondition("IS_SUNOS_SPARC", "izpack.solarisinstall.sparc");
    }

    private RulesEngine() {
        conditionsmap = new Hashtable();
        this.panelconditions = new Hashtable<String, String>();
        this.packconditions = new Hashtable<String, String>();
        this.optionalpackconditions = new Hashtable<String, String>();
    }

    private void init() {
        Debug.trace("RulesEngine.init()");
        RulesEngine.loadStaticConditions();
        if (installdata != null && RulesEngine.installdata.allPacks != null) {
            Debug.trace("Initializing builtin conditions for packs.");
            for (Pack pack : RulesEngine.installdata.allPacks) {
                if (pack.id == null) continue;
                PackselectionCondition packselectionCondition = new PackselectionCondition();
                packselectionCondition.setInstalldata(installdata);
                packselectionCondition.id = "izpack.selected." + pack.id;
                packselectionCondition.packid = pack.id;
                conditionsmap.put(packselectionCondition.id, packselectionCondition);
                Debug.trace("Pack.getCondition(): " + pack.getCondition() + " for pack " + pack.id);
                if (pack.getCondition() == null || pack.getCondition().length() <= 0) continue;
                Debug.trace("Adding pack condition " + pack.getCondition() + " for pack " + pack.id);
                this.packconditions.put(pack.id, pack.getCondition());
            }
        }
    }

    private static void createBuiltinOsCondition(String string, String string2) {
        JavaCondition javaCondition = new JavaCondition();
        javaCondition.setInstalldata(installdata);
        javaCondition.id = string2;
        javaCondition.classname = "com.izforge.izpack.util.OsVersion";
        javaCondition.fieldname = string;
        javaCondition.returnvalue = "true";
        javaCondition.returnvaluetype = "boolean";
        javaCondition.complete = true;
        conditionsmap.put(javaCondition.id, javaCondition);
    }

    public RulesEngine(XMLElement xMLElement, AutomatedInstallData automatedInstallData) {
        this();
        this.conditionsspec = xMLElement;
        installdata = automatedInstallData;
        this.readConditions();
        this.init();
    }

    public RulesEngine(Map map, AutomatedInstallData automatedInstallData) {
        this();
        Debug.trace("Initializing RulesEngine");
        installdata = automatedInstallData;
        conditionsmap = map;
        for (String string : conditionsmap.keySet()) {
            Condition condition = (Condition)conditionsmap.get(string);
            condition.setInstalldata(automatedInstallData);
        }
        this.init();
    }

    public String[] getKnownConditionIds() {
        Object[] objectArray = conditionsmap.keySet().toArray(new String[conditionsmap.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected boolean checkAttribute(String string, String string2, String string3) {
        if (string != null && string.length() > 0) {
            return true;
        }
        Debug.trace("Element " + string3 + " has to specify an attribute " + string2);
        return false;
    }

    public static Condition analyzeCondition(XMLElement xMLElement) {
        String string = xMLElement.getAttribute("id");
        String string2 = xMLElement.getAttribute("type");
        Condition condition = null;
        if (string2 != null) {
            Object object;
            String string3 = "";
            if (string2.indexOf(46) > -1) {
                string3 = string2;
            } else {
                object = string2.toLowerCase();
                string3 = "com.izforge.izpack.rules." + ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1, ((String)object).length());
                string3 = string3 + "Condition";
            }
            object = RulesEngine.class.getClassLoader();
            try {
                Class<?> clazz = ((ClassLoader)object).loadClass(string3);
                condition = (Condition)clazz.newInstance();
                condition.readFromXML(xMLElement);
                condition.setId(string);
                condition.setInstalldata(installdata);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace(string3 + " not found.");
            }
            catch (InstantiationException instantiationException) {
                Debug.trace(string3 + " couldn't be instantiated.");
            }
            catch (IllegalAccessException illegalAccessException) {
                Debug.trace("Illegal access to " + string3);
            }
        }
        return condition;
    }

    protected void readConditions() {
        if (this.conditionsspec == null) {
            Debug.trace("No specification for conditions found.");
            return;
        }
        try {
            if (this.conditionsspec.hasChildren()) {
                String string;
                Object object;
                Vector<XMLElement> vector = this.conditionsspec.getChildrenNamed("condition");
                for (XMLElement serializable2 : vector) {
                    object = RulesEngine.analyzeCondition(serializable2);
                    if (object == null) continue;
                    String string2 = ((Condition)object).getId();
                    ((Condition)object).setInstalldata(installdata);
                    if (string2 == null || "UNKNOWN".equals(string2)) continue;
                    conditionsmap.put(string2, object);
                }
                Vector<XMLElement> vector2 = this.conditionsspec.getChildrenNamed("panelcondition");
                Iterator iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    object = (XMLElement)iterator.next();
                    String string3 = ((XMLElement)object).getAttribute("panelid");
                    string = ((XMLElement)object).getAttribute("conditionid");
                    this.panelconditions.put(string3, string);
                }
                Vector<XMLElement> vector3 = this.conditionsspec.getChildrenNamed("packcondition");
                for (XMLElement xMLElement : vector3) {
                    boolean bl;
                    string = xMLElement.getAttribute("packid");
                    String string4 = xMLElement.getAttribute("conditionid");
                    this.packconditions.put(string, string4);
                    String string5 = xMLElement.getAttribute("optional");
                    if (string5 == null || !(bl = Boolean.valueOf(string5).booleanValue())) continue;
                    this.optionalpackconditions.put(string, string4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Condition getCondition(String string) {
        Condition condition = (Condition)conditionsmap.get(string);
        if (condition == null) {
            condition = RulesEngine.getConditionByExpr(new StringBuffer(string));
        }
        return condition;
    }

    protected static Condition getConditionByExpr(StringBuffer stringBuffer) {
        Condition condition = null;
        block6: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '+': {
                    Condition condition2 = (Condition)conditionsmap.get(stringBuffer.substring(0, i));
                    stringBuffer.delete(0, i + 1);
                    condition = new AndCondition(condition2, RulesEngine.getConditionByExpr(stringBuffer));
                    condition.setInstalldata(installdata);
                    continue block6;
                }
                case '|': {
                    Condition condition2 = (Condition)conditionsmap.get(stringBuffer.substring(0, i));
                    stringBuffer.delete(0, i + 1);
                    condition = new OrCondition(condition2, RulesEngine.getConditionByExpr(stringBuffer));
                    condition.setInstalldata(installdata);
                    continue block6;
                }
                case '\\': {
                    Condition condition2 = (Condition)conditionsmap.get(stringBuffer.substring(0, i));
                    stringBuffer.delete(0, i + 1);
                    condition = new XorCondition(condition2, RulesEngine.getConditionByExpr(stringBuffer));
                    condition.setInstalldata(installdata);
                    continue block6;
                }
                case '!': {
                    if (i > 0) {
                        Debug.trace("error: ! operator only allowed at position 0");
                        continue block6;
                    }
                    stringBuffer.deleteCharAt(i);
                    condition = new NotCondition(RulesEngine.getConditionByExpr(stringBuffer));
                    condition.setInstalldata(installdata);
                    continue block6;
                }
            }
        }
        if (stringBuffer.length() > 0 && (condition = (Condition)conditionsmap.get(stringBuffer.toString())) != null) {
            condition.setInstalldata(installdata);
            stringBuffer.delete(0, stringBuffer.length());
        }
        return condition;
    }

    public boolean isConditionTrue(String string, Properties properties) {
        Condition condition = RulesEngine.getCondition(string);
        if (condition == null) {
            Debug.trace("Condition (" + string + ") not found.");
            return true;
        }
        Debug.trace("Checking condition");
        try {
            return condition.isTrue();
        }
        catch (NullPointerException nullPointerException) {
            Debug.error("Nullpointerexception checking condition: " + string);
            return false;
        }
    }

    public boolean isConditionTrue(Condition condition, Properties properties) {
        if (condition == null) {
            Debug.trace("Condition not found.");
            return true;
        }
        Debug.trace("Checking condition");
        return condition.isTrue();
    }

    public boolean isConditionTrue(String string) {
        Condition condition = RulesEngine.getCondition(string);
        if (condition != null) {
            return this.isConditionTrue(condition);
        }
        return false;
    }

    public boolean isConditionTrue(Condition condition) {
        return condition.isTrue();
    }

    public boolean canShowPanel(String string, Properties properties) {
        Debug.trace("can show panel with id " + string + " ?");
        if (!this.panelconditions.containsKey(string)) {
            Debug.trace("no condition, show panel");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = RulesEngine.getCondition(this.panelconditions.get(string));
        if (condition != null) {
            return condition.isTrue();
        }
        return false;
    }

    public boolean canInstallPack(String string, Properties properties) {
        if (string == null) {
            return true;
        }
        Debug.trace("can install pack with id " + string + "?");
        if (!this.packconditions.containsKey(string)) {
            Debug.trace("no condition, can install pack");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = RulesEngine.getCondition(this.packconditions.get(string));
        if (condition != null) {
            return condition.isTrue();
        }
        return false;
    }

    public boolean canInstallPackOptional(String string, Properties properties) {
        Debug.trace("can install pack optional with id " + string + "?");
        if (!this.optionalpackconditions.containsKey(string)) {
            Debug.trace("not in optionalpackconditions.");
            return false;
        }
        Debug.trace("optional install possible");
        return true;
    }

    static {
        RulesEngine.loadStaticConditions();
    }
}

