/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.coi.tools.os.win.MSWinConstants;
import com.coi.tools.os.win.NativeLibException;
import com.coi.tools.os.win.RegDataContainer;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OSClassHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryHandler
extends OSClassHelper
implements MSWinConstants {
    public static final String UNINSTALL_ROOT = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    public static final Map<String, Integer> ROOT_KEY_MAP = new HashMap<String, Integer>();
    protected String uninstallName = null;
    private static final String UNINSTALLER_ICON = "UninstallerIcon";
    private static RegistryHandler defaultHandler = null;

    public RegistryHandler() {
    }

    public RegistryHandler(String string) {
        super(string);
        this.setDefault();
    }

    private synchronized void setDefault() {
        if (defaultHandler == null) {
            defaultHandler = this;
        }
    }

    public void setValue(String string, String string2, String string3) throws NativeLibException {
    }

    public void setValue(String string, String string2, String[] stringArray) throws NativeLibException {
    }

    public void setValue(String string, String string2, byte[] byArray) throws NativeLibException {
    }

    public void setValue(String string, String string2, long l) throws NativeLibException {
    }

    public RegDataContainer getValue(String string, String string2, RegDataContainer regDataContainer) throws NativeLibException {
        return null;
    }

    public boolean keyExist(String string) throws NativeLibException {
        return false;
    }

    public boolean valueExist(String string, String string2) throws NativeLibException {
        return false;
    }

    public String[] getSubkeys(String string) throws NativeLibException {
        return null;
    }

    public String[] getValueNames(String string) throws NativeLibException {
        return null;
    }

    public RegDataContainer getValue(String string, String string2) throws NativeLibException {
        return null;
    }

    public void createKey(String string) throws NativeLibException {
    }

    public void deleteKey(String string) throws NativeLibException {
    }

    public void deleteKeyIfEmpty(String string) throws NativeLibException {
    }

    public void deleteValue(String string, String string2) throws NativeLibException {
    }

    public void setRoot(int n) throws NativeLibException {
    }

    public int getRoot() throws NativeLibException {
        return 0;
    }

    public void activateLogging() throws NativeLibException {
    }

    public void suspendLogging() throws NativeLibException {
    }

    public void resetLogging() throws NativeLibException {
    }

    public List<Object> getLoggingInfo() throws NativeLibException {
        return null;
    }

    public void setLoggingInfo(List list) throws NativeLibException {
    }

    public void addLoggingInfo(List list) throws NativeLibException {
    }

    public void rewind() throws NativeLibException {
    }

    public String getUninstallName() {
        if (this.uninstallName != null) {
            return this.uninstallName;
        }
        if (this.installdata == null) {
            return null;
        }
        return this.installdata.getVariable("APP_NAME") + " " + this.installdata.getVariable("APP_VER");
    }

    public boolean isProductRegistered() throws NativeLibException {
        String string = this.getUninstallName();
        if (string == null) {
            return false;
        }
        String string2 = UNINSTALL_ROOT + string;
        int n = this.getRoot();
        this.setRoot(-2147483646);
        boolean bl = this.keyExist(string2);
        this.setRoot(-2147483647);
        bl = bl || this.keyExist(string2);
        this.setRoot(n);
        return bl;
    }

    public void setUninstallName(String string) {
        this.uninstallName = string;
    }

    public void registerUninstallKey() throws NativeLibException {
        String string = this.getUninstallName();
        if (string == null) {
            return;
        }
        String string2 = UNINSTALL_ROOT + string;
        String string3 = "\"" + this.installdata.getVariable("JAVA_HOME") + "\\bin\\javaw.exe\" -jar \"" + this.installdata.getVariable("INSTALL_PATH") + "\\uninstaller\\uninstaller.jar\"";
        String string4 = this.installdata.getVariable("APP_VER");
        String string5 = this.installdata.getVariable("APP_URL");
        int n = this.getRoot();
        try {
            this.setRoot(-2147483646);
            this.setValue(string2, "DisplayName", string);
        }
        catch (NativeLibException nativeLibException) {
            Debug.trace("Failed to register uninstaller in HKEY_LOCAL_MACHINE hive, trying HKEY_CURRENT_USER: " + nativeLibException.getMessage());
            this.setRoot(-2147483647);
            this.setValue(string2, "DisplayName", string);
        }
        this.setValue(string2, "UninstallString", string3);
        this.setValue(string2, "DisplayVersion", string4);
        if (string5 != null && string5.length() > 0) {
            this.setValue(string2, "HelpLink", string5);
        }
        try {
            int n2;
            InputStream inputStream = ResourceManager.getInstance().getInputStream(UNINSTALLER_ICON);
            String string6 = this.installdata.getVariable("INSTALL_PATH") + File.separator + "Uninstaller" + File.separator + "UninstallerIcon.ico";
            FileOutputStream fileOutputStream = new FileOutputStream(string6);
            byte[] byArray = new byte[5120];
            long l = 0L;
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
                l += (long)n2;
            }
            inputStream.close();
            fileOutputStream.close();
            this.setValue(string2, "DisplayIcon", string6);
        }
        catch (Exception exception) {
            Debug.trace(exception);
        }
        this.setRoot(n);
    }

    @Override
    public boolean verify(AutomatedInstallData automatedInstallData) throws Exception {
        super.verify(automatedInstallData);
        return true;
    }

    public boolean doPerform() {
        return true;
    }

    public RegistryHandler getDefaultHandler() {
        return defaultHandler;
    }

    static {
        ROOT_KEY_MAP.put("HKCR", Integer.MIN_VALUE);
        ROOT_KEY_MAP.put("HKEY_CLASSES_ROOT", Integer.MIN_VALUE);
        ROOT_KEY_MAP.put("HKCU", -2147483647);
        ROOT_KEY_MAP.put("HKEY_CURRENT_USER", -2147483647);
        ROOT_KEY_MAP.put("HKLM", -2147483646);
        ROOT_KEY_MAP.put("HKEY_LOCAL_MACHINE", -2147483646);
        ROOT_KEY_MAP.put("HKU", -2147483645);
        ROOT_KEY_MAP.put("HKEY_USERS", -2147483645);
        ROOT_KEY_MAP.put("HKPD", -2147483644);
        ROOT_KEY_MAP.put("HKEY_PERFORMANCE_DATA", -2147483644);
        ROOT_KEY_MAP.put("HKCC", -2147483643);
        ROOT_KEY_MAP.put("HKEY_CURRENT_CONFIG", -2147483643);
        ROOT_KEY_MAP.put("HKDDS", -2147483642);
        ROOT_KEY_MAP.put("HKEY_DYN_DATA", -2147483642);
    }
}

