package org.jbpm.ejb.impl;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;

public class ExecuteJobCommand implements Command {

  private final long jobId;

  private static final long serialVersionUID = 1L;

  public ExecuteJobCommand(long jobId) {
    this.jobId = jobId;
  }

  public Object execute(JbpmContext jbpmContext) throws Exception {
    JobSession jobSession = jbpmContext.getJobSession();
    Job job = jobSession.loadJob(jobId);
    job.setLockOwner(getClass().getName()); // prevent others from removing job
    log.debug("executing " + job);
    try {
      if (job.execute(jbpmContext)) {
        jobSession.deleteJob(job);
      }
    }
    catch (RuntimeException e) {
      // nothing to do but clean up and exit
      throw e;
    }
    catch (Exception e) {
      // save data about recoverable error condition
      log.error("exception while executing " + job, e);
      StringWriter memoryWriter = new StringWriter();
      e.printStackTrace(new PrintWriter(memoryWriter));
      job.setException(memoryWriter.toString());
      job.setRetries(job.getRetries() - 1);
    }
    return job;
  }

  private static Log log = LogFactory.getLog(ExecuteJobCommand.class);
}
