/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import java.io.Serializable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.command.Command;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.ejb.LocalCommandServiceHome;

public class CommandListenerBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    MessageDrivenContext messageDrivenContext = null;
    LocalCommandService commandService;
    Connection jmsConnection;
    Destination deadLetterQueue;
    private static final Log log = LogFactory.getLog(CommandListenerBean.class);

    public void onMessage(Message message) {
        try {
            Command command = this.extractCommand(message);
            if (command == null) {
                this.discard(message);
                return;
            }
            Object result = this.commandService.execute(command);
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo != null && (result instanceof Serializable || result == null)) {
                this.sendResult((Serializable)result, replyTo, message.getJMSMessageID());
            }
        }
        catch (JMSException e) {
            this.messageDrivenContext.setRollbackOnly();
            log.error((Object)("could not process message " + message), (Throwable)e);
        }
    }

    protected Command extractCommand(Message message) throws JMSException {
        Command command = null;
        if (message instanceof ObjectMessage) {
            log.debug((Object)"deserializing command from jms message...");
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable object = objectMessage.getObject();
            if (object instanceof Command) {
                command = (Command)object;
            } else {
                log.warn((Object)("ignoring object message cause it isn't a command '" + object + "'" + (object != null ? " (" + object.getClass().getName() + ")" : "")));
            }
        } else {
            log.warn((Object)("ignoring message '" + message + "' cause it isn't an ObjectMessage (" + message.getClass().getName() + ")"));
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discard(Message message) throws JMSException {
        if (this.deadLetterQueue == null) {
            try {
                InitialContext initial = new InitialContext();
                this.deadLetterQueue = (Destination)initial.lookup("java:comp/env/jms/DeadLetterQueue");
            }
            catch (NamingException e) {
                log.debug((Object)("failed to retrieve dead letter queue, rejecting message: " + message));
                this.messageDrivenContext.setRollbackOnly();
                return;
            }
        }
        Session jmsSession = this.createSession();
        try {
            jmsSession.createProducer(this.deadLetterQueue).send(message);
        }
        finally {
            jmsSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResult(Serializable result, Destination destination, String correlationId) throws JMSException {
        log.debug((Object)("sending result " + result + " to " + destination));
        Session jmsSession = this.createSession();
        try {
            ObjectMessage resultMessage = jmsSession.createObjectMessage(result);
            resultMessage.setJMSCorrelationID(correlationId);
            jmsSession.createProducer(destination).send((Message)resultMessage);
        }
        finally {
            jmsSession.close();
        }
    }

    private Session createSession() throws JMSException {
        if (this.jmsConnection == null) {
            try {
                InitialContext initial = new InitialContext();
                ConnectionFactory jmsConnectionFactory = (ConnectionFactory)initial.lookup("java:comp/env/jms/JbpmConnectionFactory");
                this.jmsConnection = jmsConnectionFactory.createConnection();
            }
            catch (NamingException e) {
                throw new EJBException("error retrieving jms connection factory", (Exception)e);
            }
        }
        return this.jmsConnection.createSession(false, 1);
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this.messageDrivenContext = messageDrivenContext;
    }

    public void ejbRemove() {
        if (this.jmsConnection != null) {
            try {
                this.jmsConnection.close();
            }
            catch (JMSException e) {
                log.debug((Object)"failed to close jms connection", (Throwable)e);
            }
            this.jmsConnection = null;
        }
        this.deadLetterQueue = null;
        this.commandService = null;
        this.messageDrivenContext = null;
    }

    public void ejbCreate() {
        try {
            InitialContext initial = new InitialContext();
            LocalCommandServiceHome commandServiceHome = (LocalCommandServiceHome)initial.lookup("java:comp/env/ejb/LocalCommandServiceBean");
            this.commandService = commandServiceHome.create();
        }
        catch (NamingException e) {
            throw new EJBException("error retrieving command service home", (Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException("error creating command service", (Exception)((Object)e));
        }
    }
}

