/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;

public class ExecuteJobCommand
implements Command {
    private final long jobId;
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ExecuteJobCommand.class);

    public ExecuteJobCommand(long jobId) {
        this.jobId = jobId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        JobSession jobSession = jbpmContext.getJobSession();
        Job job = jobSession.loadJob(this.jobId);
        job.setLockOwner(this.getClass().getName());
        log.debug((Object)("executing " + job));
        try {
            if (job.execute(jbpmContext)) {
                jobSession.deleteJob(job);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("exception while executing " + job), (Throwable)e);
            StringWriter memoryWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(memoryWriter));
            job.setException(memoryWriter.toString());
            job.setRetries(job.getRetries() - 1);
        }
        return job;
    }
}

