/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import java.io.Serializable;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.TimedObject;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.ejb.LocalCommandServiceHome;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.ejbtimer.ExecuteTimerCommand;
import org.jbpm.scheduler.ejbtimer.TimerInfo;

public abstract class TimerEntityBean
implements EntityBean,
TimedObject {
    private EntityContext entityContext;
    private LocalCommandService commandService;
    private static final Log log = LogFactory.getLog(TimerEntityBean.class);

    public abstract Long getTimerId();

    public abstract void setTimerId(Long var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract Long getTokenId();

    public abstract void setTokenId(Long var1);

    public abstract Long getProcessInstanceId();

    public abstract void setProcessInstanceId(Long var1);

    public abstract String getDiscriminator();

    public abstract void setDiscriminator(String var1);

    public void ejbActivate() {
        try {
            InitialContext initial = new InitialContext();
            LocalCommandServiceHome commandServiceHome = (LocalCommandServiceHome)initial.lookup("java:comp/env/ejb/LocalCommandServiceBean");
            this.commandService = commandServiceHome.create();
        }
        catch (NamingException e) {
            throw new EJBException("failed to retrieve command service home", (Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException("command service creation failed", (Exception)((Object)e));
        }
    }

    public void ejbPassivate() {
        this.commandService = null;
    }

    public void ejbRemove() {
        this.commandService = null;
    }

    public void ejbLoad() {
    }

    public void ejbStore() {
    }

    public void setEntityContext(EntityContext entityContext) {
        this.entityContext = entityContext;
    }

    public void unsetEntityContext() {
        this.entityContext = null;
    }

    public Long ejbCreate() throws CreateException {
        throw new CreateException("direct creation of timer entities is prohibited");
    }

    public void ejbPostCreate() {
    }

    public void ejbTimeout(javax.ejb.Timer ejbTimer) {
        log.debug((Object)(ejbTimer + " fired"));
        TimerInfo timerInfo = (TimerInfo)ejbTimer.getInfo();
        Timer timer = (Timer)this.commandService.execute(new ExecuteTimerCommand(timerInfo.getTimerId()));
        if (timer.getRepeat() != null) {
            log.debug((Object)("scheduling timer for repeat on " + timer.getDueDate()));
            this.createTimer(timer);
        }
    }

    public void createTimer(Timer timer) {
        TimerService timerService = this.entityContext.getTimerService();
        javax.ejb.Timer ejbTimer = timerService.createTimer(timer.getDueDate(), (Serializable)new TimerInfo(timer));
        log.debug((Object)("created " + ejbTimer));
    }

    public void cancelTimer(Timer timer) {
        long timerId = timer.getId();
        Collection timers = this.entityContext.getTimerService().getTimers();
        log.debug((Object)("retrieved " + timers.size() + " ejb timer(s) by id " + timerId));
        int count = 0;
        for (javax.ejb.Timer ejbTimer : timers) {
            TimerInfo timerInfo = (TimerInfo)ejbTimer.getInfo();
            if (timerInfo.getTimerId() != timerId) continue;
            ejbTimer.cancel();
            ++count;
        }
        log.debug((Object)("canceled " + count + " ejb timer(s) by id " + timerId));
    }

    public void cancelTimersByName(String timerName, Token token) {
        Collection timers = this.entityContext.getTimerService().getTimers();
        log.debug((Object)("retrieved " + timers.size() + " ejb timer(s) by name '" + timerName + "' for " + token));
        int count = 0;
        for (javax.ejb.Timer ejbTimer : timers) {
            TimerInfo timerInfo = (TimerInfo)ejbTimer.getInfo();
            if (!timerInfo.matchesName(timerName, token)) continue;
            ejbTimer.cancel();
            ++count;
        }
        log.debug((Object)("canceled " + count + " ejb timer(s) by name '" + timerName + "' for " + token));
    }

    public void cancelTimersForProcessInstance(ProcessInstance processInstance) {
        Collection timers = this.entityContext.getTimerService().getTimers();
        log.debug((Object)("retrieved " + timers.size() + " timer(s) for " + processInstance));
        int count = 0;
        for (javax.ejb.Timer ejbTimer : timers) {
            TimerInfo timerInfo = (TimerInfo)ejbTimer.getInfo();
            if (!timerInfo.matchesProcessInstance(processInstance)) continue;
            ejbTimer.cancel();
            ++count;
        }
        log.debug((Object)("canceled " + count + " ejb timer(s) for " + processInstance));
    }
}

