/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.JbpmException;
import org.jbpm.msg.jms.JmsMessageServiceImpl;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;

public class JmsMessageServiceFactoryImpl
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    String connectionFactoryJndiName = "java:comp/env/jms/JbpmConnectionFactory";
    String destinationJndiName = "java:comp/env/jms/JobQueue";
    boolean isCommitEnabled = false;
    private ConnectionFactory connectionFactory;
    private Destination destination;

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            try {
                this.connectionFactory = (ConnectionFactory)JmsMessageServiceFactoryImpl.lookup(this.connectionFactoryJndiName);
            }
            catch (NamingException e) {
                throw new JbpmException("could not retrieve message connection factory", (Throwable)e);
            }
        }
        return this.connectionFactory;
    }

    public Destination getDestination() {
        if (this.destination == null) {
            try {
                this.destination = (Destination)JmsMessageServiceFactoryImpl.lookup(this.destinationJndiName);
            }
            catch (NamingException e) {
                throw new JbpmException("could not retrieve message destination", (Throwable)e);
            }
        }
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookup(String name) throws NamingException {
        InitialContext initial = new InitialContext();
        try {
            Object object = initial.lookup(name);
            return object;
        }
        finally {
            initial.close();
        }
    }

    public Service openService() {
        try {
            Connection connection = this.getConnectionFactory().createConnection();
            Session session = connection.createSession(true, 0);
            return new JmsMessageServiceImpl(connection, session, this.getDestination(), this.isCommitEnabled);
        }
        catch (JMSException e) {
            throw new JbpmException("couldn't open message session", (Throwable)e);
        }
    }

    public void close() {
        this.connectionFactory = null;
        this.destination = null;
    }
}

