/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.msg.MessageService;

public class JmsMessageServiceImpl
implements MessageService {
    private static final long serialVersionUID = 1L;
    JobSession jobSession = null;
    Connection connection = null;
    Session session = null;
    Destination destination = null;
    MessageProducer messageProducer = null;
    boolean isCommitEnabled = false;

    public JmsMessageServiceImpl(Connection connection, Session session, Destination destination, boolean isCommitEnabled) {
        this.connection = connection;
        this.session = session;
        this.destination = destination;
        this.isCommitEnabled = isCommitEnabled;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("instantiation of the JmsMessageService requires a current JbpmContext");
        }
        this.jobSession = jbpmContext.getJobSession();
    }

    public void send(Job job) {
        try {
            this.jobSession.saveJob(job);
            Message message = this.session.createMessage();
            message.setLongProperty("jobId", job.getId());
            if (job.getToken() != null) {
                message.setLongProperty("tokenId", job.getToken().getId());
            }
            if (job.getProcessInstance() != null) {
                message.setLongProperty("processInstanceId", job.getProcessInstance().getId());
            }
            if (job.getTaskInstance() != null) {
                message.setLongProperty("taskInstanceId", job.getTaskInstance().getId());
            }
            this.getMessageProducer().send(message);
        }
        catch (JMSException e) {
            throw new JbpmException("couldn't send jms message", (Throwable)e);
        }
    }

    public void close() {
        JbpmException exception;
        block15: {
            block14: {
                exception = null;
                if (this.messageProducer != null) {
                    try {
                        this.messageProducer.close();
                    }
                    catch (Exception e) {
                        exception = new JbpmException("couldn't close message producer", (Throwable)e);
                    }
                }
                if (this.session != null) {
                    block13: {
                        if (this.isCommitEnabled) {
                            try {
                                this.session.commit();
                            }
                            catch (Exception e) {
                                if (exception != null) break block13;
                                exception = new JbpmException("couldn't commit JMS session", (Throwable)e);
                            }
                        }
                    }
                    try {
                        this.session.close();
                    }
                    catch (Exception e) {
                        if (exception != null) break block14;
                        exception = new JbpmException("couldn't close JMS session", (Throwable)e);
                    }
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    if (exception != null) break block15;
                    exception = new JbpmException("couldn't close JMS connection", (Throwable)e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected MessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = this.session.createProducer(this.destination);
        }
        return this.messageProducer;
    }
}

