/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.job.Timer;

public class ExecuteTimerCommand
implements Command {
    private final long timerId;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExecuteTimerCommand.class);

    public ExecuteTimerCommand(long timerId) {
        this.timerId = timerId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        Timer timer = jbpmContext.getJobSession().loadTimer(this.timerId);
        timer.setLockOwner(this.getClass().getName());
        log.debug((Object)("executing " + timer));
        try {
            if (timer.execute(jbpmContext)) {
                jbpmContext.getServices().getSchedulerService().deleteTimer(timer);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("exception while executing " + timer), (Throwable)e);
            StringWriter memoryWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(memoryWriter));
            timer.setException(memoryWriter.toString());
            timer.setRetries(timer.getRetries() - 1);
        }
        return timer;
    }
}

