/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.scheduler.ejbtimer.LocalTimerService;
import org.jbpm.scheduler.ejbtimer.LocalTimerServiceHome;

public class EjbSchedulerService
implements SchedulerService {
    private static final long serialVersionUID = 1L;
    JobSession jobSession;
    Session session;
    LocalTimerService timerService;
    private static Log log = LogFactory.getLog(EjbSchedulerService.class);

    public EjbSchedulerService(LocalTimerServiceHome timerServiceHome) {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("instantiation of the EjbSchedulerService requires a current JbpmContext");
        }
        this.jobSession = jbpmContext.getJobSession();
        this.session = jbpmContext.getSession();
        try {
            this.timerService = timerServiceHome.create();
        }
        catch (CreateException e) {
            throw new JbpmException("ejb local timer creation problem", (Throwable)e);
        }
    }

    public void createTimer(Timer timer) {
        log.debug((Object)("creating " + timer));
        this.jobSession.saveJob((Job)timer);
        this.session.flush();
        this.timerService.createTimer(timer);
    }

    public void deleteTimer(Timer timer) {
        log.debug((Object)("deleting " + timer));
        this.timerService.cancelTimer(timer);
        this.jobSession.deleteJob((Job)timer);
    }

    public void deleteTimersByName(String timerName, Token token) {
        log.debug((Object)("deleting timers by name '" + timerName + "' for " + token));
        this.timerService.cancelTimersByName(timerName, token);
        this.jobSession.deleteTimersByName(timerName, token);
    }

    public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
        log.debug((Object)("deleting timers for " + processInstance));
        this.timerService.cancelTimersForProcessInstance(processInstance);
        this.jobSession.deleteJobsForProcessInstance(processInstance);
    }

    public void close() {
        try {
            log.debug((Object)"removing the timer service session bean");
            this.timerService.remove();
        }
        catch (RemoveException e) {
            throw new JbpmException("ejb local timer service close problem", (Throwable)e);
        }
    }
}

