/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.ejb.LocalCommandServiceHome;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.ejbtimer.ExecuteTimerCommand;
import org.jbpm.scheduler.ejbtimer.TimerInfo;

public class TimerServiceBean
implements SessionBean,
TimedObject {
    private static final long serialVersionUID = 1L;
    SessionContext sessionContext;
    private static Log log = LogFactory.getLog(TimerServiceBean.class);

    public void ejbCreate() {
    }

    public void createTimer(Timer timer) {
        TimerService timerService = this.sessionContext.getTimerService();
        javax.ejb.Timer ejbTimer = timerService.createTimer(timer.getDueDate(), (Serializable)new TimerInfo(timer));
        log.debug((Object)("created " + ejbTimer));
    }

    public void cancelTimer(Timer timer) {
        long timerId = timer.getId();
        Collection timers = this.sessionContext.getTimerService().getTimers();
        log.debug((Object)("examining " + timers.size() + " ejb timer(s) by id " + timerId));
        int count = 0;
        for (javax.ejb.Timer ejbTimer : timers) {
            TimerInfo timerInfo;
            if (!(ejbTimer.getInfo() instanceof TimerInfo) || timerId != (timerInfo = (TimerInfo)ejbTimer.getInfo()).getTimerId()) continue;
            ejbTimer.cancel();
            ++count;
        }
        log.debug((Object)("canceled " + count + " ejb timer(s) by id " + timerId));
    }

    public void cancelTimersByName(String timerName, Token token) {
        Collection timers = this.sessionContext.getTimerService().getTimers();
        log.debug((Object)("examining " + timers.size() + " ejb timer(s) by name '" + timerName + "' for " + token));
        int count = 0;
        for (javax.ejb.Timer ejbTimer : timers) {
            TimerInfo timerInfo;
            if (!(ejbTimer.getInfo() instanceof TimerInfo) || !(timerInfo = (TimerInfo)ejbTimer.getInfo()).matchesName(timerName, token)) continue;
            ejbTimer.cancel();
            ++count;
        }
        log.debug((Object)("canceled " + count + " ejb timer(s) by name '" + timerName + "' for " + token));
    }

    public void cancelTimersForProcessInstance(ProcessInstance processInstance) {
        Collection timers = this.sessionContext.getTimerService().getTimers();
        log.debug((Object)("examining " + timers.size() + " timer(s) for " + processInstance));
        int count = 0;
        for (javax.ejb.Timer ejbTimer : timers) {
            TimerInfo timerInfo;
            if (!(ejbTimer.getInfo() instanceof TimerInfo) || !(timerInfo = (TimerInfo)ejbTimer.getInfo()).matchesProcessInstance(processInstance)) continue;
            ejbTimer.cancel();
            ++count;
        }
        log.debug((Object)("canceled " + count + " ejb timer(s) for " + processInstance));
    }

    public void ejbTimeout(javax.ejb.Timer ejbTimer) {
        log.debug((Object)(ejbTimer + " fired"));
        String localCommandServiceJndiName = "java:comp/env/ejb/LocalCommandServiceBean";
        try {
            InitialContext initial = new InitialContext();
            LocalCommandServiceHome localCommandServiceHome = (LocalCommandServiceHome)initial.lookup(localCommandServiceJndiName);
            LocalCommandService localCommandService = localCommandServiceHome.create();
            Serializable info = ejbTimer.getInfo();
            if (!(info instanceof TimerInfo)) {
                if (info == null) {
                    throw new NullPointerException("timer info is null");
                }
                throw new ClassCastException("timer info (" + info.getClass().getName() + ") is not of the expected class " + TimerInfo.class.getName());
            }
            TimerInfo timerInfo = (TimerInfo)info;
            Timer timer = (Timer)localCommandService.execute(new ExecuteTimerCommand(timerInfo.getTimerId()));
            if (timer != null && timer.getRepeat() != null) {
                log.debug((Object)("scheduling timer for repeat at " + timer.getDueDate()));
                this.createTimer(timer);
            }
        }
        catch (Exception e) {
            JbpmException jbpmException = new JbpmException("couldn't execute timer", (Throwable)e);
            log.error((Object)jbpmException);
            throw jbpmException;
        }
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException, RemoteException {
        this.sessionContext = sessionContext;
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }
}

