/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jbpm.integration.spec.deployment.AbstractDeployment;
import org.jbpm.util.IoUtil;

public class PARDeployment
extends AbstractDeployment {
    private static final String PROCESSDEFINITION_ENTRY = "processdefinition.xml";
    private URL pdURL;

    public PARDeployment(URL pdURL) {
        this.pdURL = pdURL;
    }

    public String getProcessDefinitionXML() throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(this.pdURL.openStream());
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String entryName = zipEntry.getName();
            byte[] bytes = IoUtil.readBytes((InputStream)zipInputStream);
            if (bytes != null) {
                this.addAttachment(entryName, bytes);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        byte[] pdBytes = (byte[])this.getAttachment(PROCESSDEFINITION_ENTRY);
        if (pdBytes == null) {
            throw new IllegalStateException("Cannot obtain 'processdefinition.xml' from: " + this.pdURL);
        }
        String pdXML = new String(pdBytes);
        return pdXML;
    }
}

