/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.model;

import java.io.Serializable;
import org.jboss.bpm.api.model.AbstractElement;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.Identifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementImpl<T extends Identifiable>
implements AbstractElement {
    private static final long serialVersionUID = 1L;
    private ProcessEngine engine;
    private T tempObj;
    private Class<T> objClass;
    private long objID;

    public AbstractElementImpl(ProcessEngine engine, Identifiable tempObj, Class<T> objClass) {
        this.engine = engine;
        this.objClass = objClass;
        this.objID = tempObj.getId();
        if (this.objID == 0L) {
            this.tempObj = tempObj;
        }
    }

    public ProcessEngine getProcessEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDelegate() {
        Identifiable retObj = null;
        long currID = this.objID;
        if (currID == 0L && this.tempObj != null) {
            currID = this.tempObj.getId();
        }
        if (currID == 0L && this.tempObj != null) {
            retObj = (Identifiable)this.tempObj;
        }
        if (retObj == null) {
            if (this.objClass == null || currID == 0L) {
                throw new IllegalArgumentException("Cannot obtain delegate for '" + this.objClass + "' id: " + currID);
            }
            this.objID = currID;
            this.tempObj = null;
            ContextService execService = (ContextService)this.getProcessEngine().getService(ContextService.class);
            Context bpmContext = execService.getContext(true);
            try {
                JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
                Object obj = jbpmContext.getSession().get(this.objClass, (Serializable)Long.valueOf(this.objID));
                retObj = (Identifiable)obj;
            }
            finally {
                bpmContext.close();
            }
        }
        if (retObj == null) {
            throw new IllegalStateException("Cannot obtain delegate for '" + this.objClass.getName() + "' id: " + this.objID);
        }
        return (T)retObj;
    }
}

