/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.bpm.api.InvalidProcessException;
import org.jboss.bpm.api.NotImplementedException;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessEngineSupport;
import org.jboss.bpm.incubator.model.Expression;
import org.jboss.bpm.incubator.model.SequenceFlow;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.integration.spec.model.AbstractElementImpl;
import org.jbpm.integration.spec.model.EndEventImpl;
import org.jbpm.integration.spec.model.ExclusiveGatewayImpl;
import org.jbpm.integration.spec.model.ExpressionImpl;
import org.jbpm.integration.spec.model.NodeImpl;
import org.jbpm.integration.spec.model.NoneTaskImpl;
import org.jbpm.integration.spec.model.ParallelGatewayForkImpl;
import org.jbpm.integration.spec.model.ParallelGatewayJoinImpl;
import org.jbpm.integration.spec.model.ProcessInstanceImpl;
import org.jbpm.integration.spec.model.SequenceFlowImpl;
import org.jbpm.integration.spec.model.StartEventImpl;
import org.jbpm.integration.spec.model.UserTaskImpl;
import org.jbpm.integration.spec.model.WaitStateImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionImpl
extends AbstractElementImpl<ProcessDefinition>
implements org.jboss.bpm.api.model.ProcessDefinition {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionImpl.class);
    private ObjectName keyCache;
    private List<Node> nodes;

    public static org.jboss.bpm.api.model.ProcessDefinition newInstance(ProcessEngine engine, ProcessDefinition tmpProcDef, boolean proxy) {
        ProcessDefinitionImpl procDef = new ProcessDefinitionImpl(engine, tmpProcDef);
        if (proxy) {
            procDef = InvocationProxy.newInstance((ProcessEngineSupport)procDef, org.jboss.bpm.api.model.ProcessDefinition.class);
        }
        return procDef;
    }

    private ProcessDefinitionImpl(ProcessEngine engine, ProcessDefinition tmpProcDef) {
        super(engine, (Identifiable)tmpProcDef, ProcessDefinition.class);
        if (tmpProcDef.getName() == null) {
            throw new InvalidProcessException("ProcessDefinition name cannot be null");
        }
        if (tmpProcDef.getId() > 0L) {
            this.keyCache = ProcessDefinitionImpl.getKey(tmpProcDef);
        }
    }

    public ObjectName getKey() {
        ObjectName objKey = this.keyCache;
        if (objKey == null) {
            ProcessDefinition delegate = (ProcessDefinition)this.getDelegate();
            objKey = ProcessDefinitionImpl.getKey(delegate);
            if (delegate.getId() > 0L) {
                this.keyCache = objKey;
            }
        }
        return objKey;
    }

    public static ObjectName getKey(ProcessDefinition oldProcDef) {
        long id = oldProcDef.getId();
        int version = oldProcDef.getVersion();
        String keyStr = "jboss.jbpm:procdef=" + oldProcDef.getName() + ",id=" + id;
        if (version > 0) {
            keyStr = keyStr + ",version=" + version;
        }
        return ObjectNameFactory.create((String)keyStr);
    }

    public String getName() {
        return ((ProcessDefinition)this.getDelegate()).getName();
    }

    public String getVersion() {
        int version = ((ProcessDefinition)this.getDelegate()).getVersion();
        return version > 0 ? String.valueOf(version) : null;
    }

    public ProcessInstance newInstance() {
        org.jbpm.graph.exe.ProcessInstance oldProcInst = new org.jbpm.graph.exe.ProcessInstance();
        oldProcInst.setProcessDefinition((ProcessDefinition)this.getDelegate());
        oldProcInst.addInitialModuleDefinitions((ProcessDefinition)this.getDelegate());
        return ProcessInstanceImpl.newInstance(this.getProcessEngine(), oldProcInst, true);
    }

    public void addNode(NodeImpl<?> nodeImpl) {
        org.jbpm.graph.def.Node oldNode = (org.jbpm.graph.def.Node)nodeImpl.getDelegate();
        ((ProcessDefinition)this.getDelegate()).addNode(oldNode);
    }

    public Node getNode(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find node with name: null");
        }
        Node retNode = null;
        for (Node auxNode : this.getNodes()) {
            if (!name.equals(auxNode.getName())) continue;
            retNode = auxNode;
            break;
        }
        return retNode;
    }

    public List<Node> getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
            ProcessEngine engine = this.getProcessEngine();
            for (org.jbpm.graph.def.Node oldNode : ((ProcessDefinition)this.getDelegate()).getNodes()) {
                NodeImpl nodeImpl;
                Node.NodeType nodeType = oldNode.getNodeType();
                if (nodeType == Node.NodeType.StartState) {
                    nodeImpl = new StartEventImpl(engine, this, oldNode);
                } else if (nodeType == Node.NodeType.State) {
                    nodeImpl = new WaitStateImpl(engine, this, oldNode);
                } else if (nodeType == Node.NodeType.Fork) {
                    nodeImpl = new ParallelGatewayForkImpl(engine, this, oldNode);
                } else if (nodeType == Node.NodeType.Join) {
                    nodeImpl = new ParallelGatewayJoinImpl(engine, this, oldNode);
                } else if (nodeType == Node.NodeType.Decision) {
                    nodeImpl = new ExclusiveGatewayImpl(engine, this, oldNode);
                } else if (nodeType == Node.NodeType.Task) {
                    nodeImpl = new UserTaskImpl(engine, this, oldNode);
                } else if (nodeType == Node.NodeType.EndState) {
                    nodeImpl = new EndEventImpl(engine, this, oldNode);
                } else if (nodeType == Node.NodeType.Node) {
                    nodeImpl = new NoneTaskImpl(engine, this, oldNode);
                } else {
                    throw new NotImplementedException("Unsupported node type: " + nodeType);
                }
                this.nodes.add(nodeImpl);
            }
            this.initializeSequenceFlows(this.nodes);
        }
        return Collections.unmodifiableList(this.nodes);
    }

    public <T extends Node> T getNode(Class<T> clazz, String name) {
        for (Node node : this.getNodes(clazz)) {
            if (!node.getName().equals(name)) continue;
            return (T)node;
        }
        return null;
    }

    public <T extends Node> List<T> getNodes(Class<T> clazz) {
        ArrayList<Node> retNodes = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            if (!clazz.isAssignableFrom(node.getClass())) continue;
            retNodes.add(node);
        }
        return retNodes;
    }

    private void initializeSequenceFlows(List<Node> nodes) {
        for (Node node : nodes) {
            NodeImpl nodeImpl = (NodeImpl)node;
            org.jbpm.graph.def.Node oldNode = (org.jbpm.graph.def.Node)nodeImpl.getDelegate();
            if (oldNode.getLeavingTransitions() == null) continue;
            for (Transition trans : oldNode.getLeavingTransitions()) {
                SequenceFlowImpl seqFlow = new SequenceFlowImpl(trans);
                String condition = trans.getCondition();
                if (condition != null) {
                    Expression expr = ExpressionImpl.valueOf(condition);
                    if (condition.equals("[" + SequenceFlow.ConditionType.Default + "]")) {
                        seqFlow = new SequenceFlowImpl(trans, true);
                    } else if (expr != null) {
                        seqFlow = new SequenceFlowImpl(trans, expr.getExpressionLanguage(), expr.getExpressionBody());
                    } else {
                        log.warn("Cannot translate flow condition: " + condition);
                    }
                }
                nodeImpl.addSequenceFlow(seqFlow);
            }
        }
    }

    public String toString() {
        return "ProcessDefinition[" + this.getKey() + "]";
    }
}

