/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.runtime;

import java.util.HashMap;
import org.jboss.bpm.api.runtime.Attachments;
import org.jboss.bpm.api.runtime.Token;
import org.jboss.bpm.incubator.model.Expression;
import org.mvel.MVEL;

public class ExpressionEvaluator {
    private Expression expr;

    public ExpressionEvaluator(Expression expr) {
        this.expr = expr;
    }

    public Object evaluateExpression(Token token) {
        Expression.ExpressionLanguage exprLang = this.expr.getExpressionLanguage();
        if (exprLang == Expression.ExpressionLanguage.MVEL) {
            String mvel = this.expr.getExpressionBody();
            Attachments atts = token.getAttachments();
            HashMap<String, Object> vars = new HashMap<String, Object>();
            for (Attachments.Key key : atts.getAttachmentKeys()) {
                String name = key.getNamePart();
                Object value = atts.getAttachment(name);
                vars.put(name.replace(".", "_"), value);
            }
            return MVEL.eval((String)mvel, vars);
        }
        throw new IllegalStateException("Unsupported expression language: " + exprLang);
    }
}

