/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.runtime;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.runtime.Attachments;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.runtime.Token;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessEngineSupport;
import org.jboss.bpm.incubator.model.SequenceFlow;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.Transition;
import org.jbpm.integration.spec.model.AbstractElementImpl;
import org.jbpm.integration.spec.model.NodeImpl;
import org.jbpm.integration.spec.model.ProcessInstanceImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;
import org.jbpm.integration.spec.runtime.TokenAttachmentDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenImpl
extends AbstractElementImpl<org.jbpm.graph.exe.Token>
implements Token {
    private static final long serialVersionUID = 1L;
    private ObjectName keyCache;
    private SequenceFlow lastFlow;
    private Attachments att;

    public static Token newInstance(ProcessEngine engine, org.jbpm.graph.exe.Token tmpToken) {
        return InvocationProxy.newInstance((ProcessEngineSupport)new TokenImpl(engine, tmpToken), Token.class);
    }

    private TokenImpl(ProcessEngine engine, org.jbpm.graph.exe.Token tmpToken) {
        super(engine, (Identifiable)tmpToken, org.jbpm.graph.exe.Token.class);
        ContextInstance context = tmpToken.getProcessInstance().getContextInstance();
        this.att = new TokenAttachmentDelegate(this, context);
        if (tmpToken.getId() > 0L) {
            this.keyCache = TokenImpl.getKey(tmpToken);
        }
    }

    public ObjectName getKey() {
        ObjectName objKey = this.keyCache;
        if (objKey == null) {
            org.jbpm.graph.exe.Token delegate = (org.jbpm.graph.exe.Token)this.getDelegate();
            objKey = TokenImpl.getKey(delegate);
            if (delegate.getId() > 0L) {
                this.keyCache = objKey;
            }
        }
        return objKey;
    }

    public static ObjectName getKey(org.jbpm.graph.exe.Token oldToken) {
        return ObjectNameFactory.create((String)("jboss.jbpm:id=" + oldToken.getId()));
    }

    public ProcessInstance getProcess() {
        return ProcessInstanceImpl.newInstance(this.getProcessEngine(), ((org.jbpm.graph.exe.Token)this.getDelegate()).getProcessInstance(), true);
    }

    public Attachments getAttachments() {
        return this.att;
    }

    public Token.TokenStatus getTokenStatus() {
        Token.TokenStatus status = Token.TokenStatus.Suspended;
        if (((org.jbpm.graph.exe.Token)this.getDelegate()).hasEnded()) {
            status = Token.TokenStatus.Destroyed;
        }
        return status;
    }

    public Set<Token> getChildTokens() {
        HashSet<Token> childTokens = new HashSet<Token>();
        Map oldChildMap = ((org.jbpm.graph.exe.Token)this.getDelegate()).getChildren();
        if (oldChildMap != null) {
            for (org.jbpm.graph.exe.Token oldChildToken : oldChildMap.values()) {
                if (oldChildToken.hasEnded()) continue;
                Token childToken = TokenImpl.newInstance(this.getProcessEngine(), oldChildToken);
                childTokens.add(childToken);
            }
        }
        return childTokens;
    }

    public Node getNode() {
        String nodeName = ((org.jbpm.graph.exe.Token)this.getDelegate()).getNode().getNameExt();
        return this.getProcess().getNode(nodeName);
    }

    public SequenceFlow getLastFlow() {
        return this.lastFlow;
    }

    public Token getParentToken() {
        Token token = null;
        if (((org.jbpm.graph.exe.Token)this.getDelegate()).getParent() != null) {
            token = TokenImpl.newInstance(this.getProcessEngine(), ((org.jbpm.graph.exe.Token)this.getDelegate()).getParent());
        }
        return token;
    }

    public Token getRootToken() {
        org.jbpm.graph.exe.Token root = (org.jbpm.graph.exe.Token)this.getDelegate();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Token token = TokenImpl.newInstance(this.getProcessEngine(), root);
        return token;
    }

    public void signal() {
        this.signalInternal(null);
    }

    public void signal(String name) {
        this.signalInternal(name);
    }

    private void signalInternal(String name) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            Transition trans;
            NodeImpl currNode = (NodeImpl)this.getNode();
            if (currNode == null) {
                throw new IllegalStateException("Cannot signal token with no current node: " + this);
            }
            boolean hasActiveChild = false;
            for (Token child : this.getChildTokens()) {
                if (child.getTokenStatus() == Token.TokenStatus.Destroyed) continue;
                hasActiveChild = true;
                break;
            }
            if (hasActiveChild) {
                throw new IllegalStateException("Cannot signal token with active child tokens: " + this);
            }
            if (name != null) {
                trans = ((org.jbpm.graph.def.Node)currNode.getDelegate()).getLeavingTransition(name);
                this.lastFlow = currNode.getOutFlowByTransition(trans);
                ((org.jbpm.graph.exe.Token)this.getDelegate()).signal(name);
            } else {
                trans = ((org.jbpm.graph.def.Node)currNode.getDelegate()).getDefaultLeavingTransition();
                this.lastFlow = currNode.getOutFlowByTransition(trans);
                ((org.jbpm.graph.exe.Token)this.getDelegate()).signal();
            }
            JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
            jbpmContext.save((org.jbpm.graph.exe.Token)this.getDelegate());
        }
        catch (RuntimeException rte) {
            ProcessInstanceImpl procImpl = InvocationProxy.getUnderlying(this.getProcess(), ProcessInstanceImpl.class);
            procImpl.setProcessStatus(ProcessInstance.ProcessStatus.Aborted);
            throw rte;
        }
        finally {
            bpmContext.close();
        }
    }

    public String toString() {
        Node currNode = this.getNode();
        int children = this.getChildTokens().size();
        boolean root = this.getParentToken() == null;
        Token.TokenStatus status = this.getTokenStatus();
        return "[key=" + this.getKey() + ",root=" + root + ",status=" + status + ",node=" + currNode + ",flow=" + this.lastFlow + ",child=" + children + "]";
    }
}

