/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import java.util.Map;
import org.jboss.bpm.api.runtime.BasicAttachments;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.jbpm.JbpmContext;
import org.jbpm.integration.spec.service.EventServiceFactory;
import org.jbpm.integration.spec.service.MutableService;
import org.jbpm.integration.spec.service.ProcessEngineImpl;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextServiceImpl
extends AbstractService
implements ContextService,
MutableService {
    static final Logger log = LoggerFactory.getLogger(ContextServiceImpl.class);
    private static ThreadLocal<ContextImpl> contextAssociation = new ThreadLocal();

    public void setProcessEngine(ProcessEngine engine) {
        super.setProcessEngine(engine);
    }

    public Context createContext() {
        ProcessEngineImpl engineImpl = (ProcessEngineImpl)this.getProcessEngine();
        JbpmContext jbpmContext = engineImpl.getJbpmConfiguration().createJbpmContext();
        ContextImpl currContext = new ContextImpl(jbpmContext);
        contextAssociation.set(currContext);
        return currContext;
    }

    public Context getContext(boolean create) {
        ContextImpl currContext = contextAssociation.get();
        if (currContext == null && create) {
            currContext = (ContextImpl)this.createContext();
        }
        if (currContext != null) {
            currContext.clientCount++;
        }
        return currContext;
    }

    class ContextImpl
    extends BasicAttachments
    implements Context {
        private JbpmContext jbpmContext;
        private int clientCount;

        ContextImpl(JbpmContext jbpmContext) {
            this.jbpmContext = jbpmContext;
            this.addAttachment(JbpmContext.class, jbpmContext);
            Services services = jbpmContext.getServices();
            ServiceFactory serviceFactory = services.getServiceFactory("event");
            if (serviceFactory == null) {
                Map factories = services.getServiceFactories();
                factories.put("event", new EventServiceFactory(ContextServiceImpl.this.getProcessEngine()));
            }
        }

        public void close() {
            --this.clientCount;
            if (this.clientCount < 0) {
                throw new IllegalStateException("PersistenceContext already closed");
            }
            if (this.clientCount == 0) {
                contextAssociation.set(null);
                this.jbpmContext.close();
            }
        }
    }
}

