/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessInstanceService;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.jboss.bpm.incubator.service.TaskInstanceService;
import org.jbpm.JbpmContext;
import org.jbpm.integration.spec.model.ProcessInstanceImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;
import org.jbpm.integration.spec.service.MutableService;
import org.jbpm.integration.spec.task.TaskInstanceImpl;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInstanceServiceImpl
extends AbstractService
implements TaskInstanceService,
MutableService {
    final Logger log = LoggerFactory.getLogger(TaskInstanceServiceImpl.class);

    @Override
    public void setProcessEngine(ProcessEngine engine) {
        super.setProcessEngine(engine);
    }

    public List<org.jboss.bpm.incubator.task.TaskInstance> getTasksByProcess(ObjectName procID) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            ProcessInstanceService procService = (ProcessInstanceService)this.getProcessEngine().getService(ProcessInstanceService.class);
            ProcessInstance proc = procService.getInstance(procID);
            if (proc == null) {
                throw new IllegalStateException("Cannot obtain process: " + procID);
            }
            ArrayList<org.jboss.bpm.incubator.task.TaskInstance> tasks = new ArrayList<org.jboss.bpm.incubator.task.TaskInstance>();
            ProcessInstanceImpl procImpl = InvocationProxy.getUnderlying(proc, ProcessInstanceImpl.class);
            Collection oldTaskInstances = ((org.jbpm.graph.exe.ProcessInstance)procImpl.getDelegate()).getTaskMgmtInstance().getTaskInstances();
            for (TaskInstance oldTaskInst : oldTaskInstances) {
                org.jboss.bpm.incubator.task.TaskInstance task = TaskInstanceImpl.newInstance(this.getProcessEngine(), oldTaskInst);
                tasks.add(task);
            }
            ArrayList<org.jboss.bpm.incubator.task.TaskInstance> arrayList = tasks;
            return arrayList;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            bpmContext.close();
        }
    }

    public org.jboss.bpm.incubator.task.TaskInstance getTask(ObjectName taskID) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
            TaskInstance oldTaskInst = jbpmContext.getTaskInstance(this.adaptKey(taskID).longValue());
            org.jboss.bpm.incubator.task.TaskInstance taskInstance = TaskInstanceImpl.newInstance(this.getProcessEngine(), oldTaskInst);
            return taskInstance;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            bpmContext.close();
        }
    }

    public List<org.jboss.bpm.incubator.task.TaskInstance> getTasksByActor(String actor) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            ArrayList<org.jboss.bpm.incubator.task.TaskInstance> tasks = new ArrayList<org.jboss.bpm.incubator.task.TaskInstance>();
            JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
            for (TaskInstance oldTaskInst : jbpmContext.getTaskList(actor)) {
                org.jboss.bpm.incubator.task.TaskInstance taskInst = TaskInstanceImpl.newInstance(this.getProcessEngine(), oldTaskInst);
                tasks.add(taskInst);
            }
            ArrayList<org.jboss.bpm.incubator.task.TaskInstance> arrayList = tasks;
            return arrayList;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            bpmContext.close();
        }
    }

    public void closeTask(ObjectName taskID, String signalName) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            TaskInstanceImpl taskImpl = InvocationProxy.getUnderlying(this.getTask(taskID), TaskInstanceImpl.class);
            TaskInstance oldTaskInst = (TaskInstance)taskImpl.getDelegate();
            if (signalName != null) {
                oldTaskInst.end(signalName);
            } else {
                oldTaskInst.end();
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            bpmContext.close();
        }
    }

    public void reassignTask(ObjectName taskID, String actor) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            TaskInstanceImpl taskImpl = InvocationProxy.getUnderlying(this.getTask(taskID), TaskInstanceImpl.class);
            TaskInstance oldTaskInst = (TaskInstance)taskImpl.getDelegate();
            if (oldTaskInst.getStart() != null) {
                this.log.warn("Force stop on task " + oldTaskInst.getId() + ". Will be restarted.");
                oldTaskInst.setStart(null);
            }
            oldTaskInst.start(actor, true);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            bpmContext.close();
        }
    }

    private Long adaptKey(ObjectName key) {
        String id = key.getKeyProperty("id");
        if (id == null) {
            throw new IllegalStateException("Cannot obtain id property from: " + key);
        }
        return new Long(id);
    }
}

