/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessEngineSupport;
import org.jbpm.integration.spec.runtime.InvocationProxySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationProxy
implements InvocationProxySupport,
InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(InvocationProxy.class);
    private static List<Method> proxyMethods = Arrays.asList(InvocationProxySupport.class.getMethods());
    private ProcessEngineSupport obj;
    private ProcessEngine engine;

    public static <T> T newInstance(ProcessEngineSupport obj, Class<T> interf) {
        Class[] interfaces = new Class[]{interf, InvocationProxySupport.class};
        ClassLoader classLoader = obj.getClass().getClassLoader();
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new InvocationProxy(obj));
    }

    public static <T> T getUnderlying(Object implObj, Class<T> implClazz) {
        Object underlyingImpl;
        if (implClazz.isInstance(implObj)) {
            underlyingImpl = implObj;
        } else if (implObj instanceof InvocationProxySupport) {
            InvocationProxySupport proxy = (InvocationProxySupport)implObj;
            underlyingImpl = proxy.getUnderlying();
        } else {
            throw new IllegalArgumentException("Cannot obtain underlying implementation from: " + implObj);
        }
        return (T)underlyingImpl;
    }

    private InvocationProxy(ProcessEngineSupport obj) {
        this.engine = obj.getProcessEngine();
        this.obj = obj;
    }

    @Override
    public ProcessEngineSupport getUnderlying() {
        return this.obj;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (proxyMethods.contains(m)) {
            return m.invoke((Object)this, args);
        }
        Throwable targetException = null;
        ContextService ctxService = (ContextService)this.engine.getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            Object object = m.invoke((Object)this.obj, args);
            return object;
        }
        catch (InvocationTargetException ex) {
            targetException = ex.getTargetException();
            throw targetException;
        }
        finally {
            try {
                bpmContext.close();
            }
            catch (Throwable th) {
                if (targetException == null) {
                    throw th;
                }
                log.error("Cannot close the execution context", th);
                throw targetException;
            }
        }
    }
}

