/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import java.io.IOException;
import java.net.URL;
import javax.management.ObjectName;
import org.jboss.bpm.api.deployment.Deployment;
import org.jboss.bpm.api.model.ProcessDefinition;
import org.jboss.bpm.api.service.DeploymentService;
import org.jboss.bpm.api.service.ProcessDefinitionService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.jbpm.integration.spec.deployment.AbstractDeployment;
import org.jbpm.integration.spec.deployment.PARDeployment;
import org.jbpm.integration.spec.deployment.XMLDeployment;
import org.jbpm.integration.spec.service.MutableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentServiceImpl
extends AbstractService
implements DeploymentService,
MutableService {
    final Logger log = LoggerFactory.getLogger(DeploymentServiceImpl.class);

    public void setProcessEngine(ProcessEngine engine) {
        super.setProcessEngine(engine);
    }

    public Deployment createDeployment(URL depURL) {
        AbstractDeployment dep;
        if (depURL.toExternalForm().endsWith("xml")) {
            dep = new XMLDeployment(depURL);
        } else if (depURL.toExternalForm().endsWith("par")) {
            dep = new PARDeployment(depURL);
        } else {
            throw new IllegalArgumentException("Unsupported deployment URL: " + depURL);
        }
        return dep;
    }

    public ProcessDefinition deploy(Deployment dep) {
        try {
            String pdXML = dep.getProcessDefinitionXML();
            ProcessDefinitionService pdService = (ProcessDefinitionService)this.getProcessEngine().getService(ProcessDefinitionService.class);
            ProcessDefinition procDef = pdService.parseProcessDefinition(pdXML);
            procDef = pdService.registerProcessDefinition(procDef);
            dep.addAttachment(ObjectName.class, "procDefKey", (Object)procDef.getKey());
            return procDef;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot deploy: dep");
        }
    }

    public boolean undeploy(Deployment dep) {
        ObjectName key = (ObjectName)dep.getAttachment(ObjectName.class, "procDefKey");
        ProcessDefinitionService pdService = (ProcessDefinitionService)this.getProcessEngine().getService(ProcessDefinitionService.class);
        return pdService.unregisterProcessDefinition(key);
    }
}

