/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import javax.management.ObjectName;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.Signal;
import org.jboss.bpm.api.model.builder.SignalBuilder;
import org.jboss.bpm.api.service.ProcessDefinitionService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.SignalBuilderService;
import org.jboss.bpm.api.service.SignalService;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.integration.spec.model.ProcessDefinitionImpl;
import org.jbpm.signal.EventService;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServiceFactory
implements ServiceFactory {
    static final Logger log = LoggerFactory.getLogger(EventServiceFactory.class);
    private static final long serialVersionUID = 1L;
    private ProcessEngine engine;

    public EventServiceFactory(ProcessEngine engine) {
        this.engine = engine;
    }

    public Service openService() {
        return new EventServiceImpl();
    }

    public void close() {
    }

    class EventServiceImpl
    implements EventService {
        private static final long serialVersionUID = 1L;

        EventServiceImpl() {
        }

        public void fireEvent(String eventType, GraphElement graphElement, ExecutionContext executionContext) {
            SignalBuilderService sigBuilderService = (SignalBuilderService)EventServiceFactory.this.engine.getService(SignalBuilderService.class);
            SignalService sigService = (SignalService)EventServiceFactory.this.engine.getService(SignalService.class);
            if (sigBuilderService != null && sigService != null) {
                SignalBuilder sigBuilder = sigBuilderService.getSignalBuilder();
                Signal.SignalType sigType = this.getSignalType(eventType, graphElement);
                ObjectName fromRef = this.getFromRef(graphElement);
                if (sigType != null && fromRef != null) {
                    Signal signal = sigBuilder.newSignal(sigType, fromRef, null);
                    sigService.throwSignal(signal);
                } else {
                    log.debug("Cannot map to signal: [" + eventType + "," + graphElement + "]");
                }
            }
        }

        private ObjectName getFromRef(GraphElement graphElement) {
            ObjectName fromRef = null;
            ProcessDefinitionService pdService = (ProcessDefinitionService)EventServiceFactory.this.engine.getService(ProcessDefinitionService.class);
            ProcessDefinition oldProcDef = graphElement.getProcessDefinition();
            ObjectName pdKey = ProcessDefinitionImpl.getKey(oldProcDef);
            org.jboss.bpm.api.model.ProcessDefinition procDef = pdService.getProcessDefinition(pdKey);
            if (graphElement instanceof ProcessDefinition) {
                fromRef = pdKey;
            } else if (graphElement instanceof org.jbpm.graph.def.Node) {
                org.jbpm.graph.def.Node oldNode = (org.jbpm.graph.def.Node)graphElement;
                Node node = procDef.getNode(oldNode.getNameExt());
                fromRef = node.getKey();
            }
            return fromRef;
        }

        private Signal.SignalType getSignalType(String eventType, GraphElement graphElement) {
            Node.NodeType nodeType = null;
            if (graphElement instanceof org.jbpm.graph.def.Node) {
                org.jbpm.graph.def.Node oldNode = (org.jbpm.graph.def.Node)graphElement;
                nodeType = oldNode.getNodeType();
            }
            Signal.SignalType sigType = null;
            if ("process-start".equals(eventType)) {
                sigType = Signal.SignalType.SYSTEM_PROCESS_ENTER;
            } else if ("process-end".equals(eventType)) {
                sigType = Signal.SignalType.SYSTEM_PROCESS_EXIT;
            } else if ("before-signal".equals(eventType) && nodeType == Node.NodeType.StartState) {
                sigType = Signal.SignalType.SYSTEM_START_EVENT_ENTER;
            } else if ("node-leave".equals(eventType) && nodeType == Node.NodeType.StartState) {
                sigType = Signal.SignalType.SYSTEM_START_EVENT_EXIT;
            } else if ("node-enter".equals(eventType) && nodeType == Node.NodeType.EndState) {
                sigType = Signal.SignalType.SYSTEM_END_EVENT_ENTER;
            } else if ("node-leave".equals(eventType) && nodeType == Node.NodeType.EndState) {
                sigType = Signal.SignalType.SYSTEM_END_EVENT_EXIT;
            } else if ("node-enter".equals(eventType) && nodeType == Node.NodeType.State) {
                sigType = Signal.SignalType.SYSTEM_TASK_ENTER;
            } else if ("node-leave".equals(eventType) && nodeType == Node.NodeType.State) {
                sigType = Signal.SignalType.SYSTEM_TASK_EXIT;
            }
            return sigType;
        }

        public void close() {
        }
    }
}

