/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.bpm.api.InvalidProcessException;
import org.jboss.bpm.api.NotImplementedException;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.model.ProcessDefinition;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.incubator.model.SequenceFlow;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.Transition;
import org.jbpm.integration.spec.model.AbstractElementImpl;
import org.jbpm.integration.spec.model.SequenceFlowImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImpl<T extends org.jbpm.graph.def.Node>
extends AbstractElementImpl<T>
implements Node {
    private static final long serialVersionUID = 1L;
    private ProcessDefinition procDef;
    private List<SequenceFlow> outFlows = new ArrayList<SequenceFlow>();
    private List<SequenceFlow> inFlows = new ArrayList<SequenceFlow>();

    public NodeImpl(ProcessEngine engine, ProcessDefinition procDef, Class<T> clazz, org.jbpm.graph.def.Node oldNode) {
        super(engine, (Identifiable)oldNode, clazz);
        this.procDef = procDef;
    }

    public ObjectName getKey() {
        long id = ((org.jbpm.graph.def.Node)this.getDelegate()).getId();
        return ObjectNameFactory.create((String)("jboss.jbpm:node=" + this.getName() + ",id=" + id));
    }

    public String getName() {
        return ((org.jbpm.graph.def.Node)this.getDelegate()).getNameExt();
    }

    public ProcessDefinition getProcessDefinition() {
        return this.procDef;
    }

    public ProcessInstance getProcessInstance() {
        throw new NotImplementedException();
    }

    public void addSequenceFlow(SequenceFlowImpl flow) {
        Transition trans;
        String targetRef = flow.getTargetRef();
        NodeImpl targetNode = (NodeImpl)this.procDef.getNode(targetRef);
        if (targetNode == null) {
            throw new InvalidProcessException("Cannot obtain target node: " + targetRef);
        }
        org.jbpm.graph.def.Node delegate = (org.jbpm.graph.def.Node)this.getDelegate();
        if (!delegate.hasLeavingTransition((trans = flow.getOldTransition()).getName())) {
            delegate.addLeavingTransition(trans);
            ((org.jbpm.graph.def.Node)targetNode.getDelegate()).addArrivingTransition(trans);
        }
        if (flow.getConditionType() == SequenceFlow.ConditionType.Expression) {
            trans.setCondition(flow.getConditionExpression().toString());
        } else if (flow.getConditionType() == SequenceFlow.ConditionType.Default) {
            trans.setCondition("[" + SequenceFlow.ConditionType.Default + "]");
        }
        targetNode.inFlows.add(flow);
        this.outFlows.add(flow);
    }

    public SequenceFlow getOutFlowByTransition(Transition trans) {
        SequenceFlow outFlow = null;
        for (SequenceFlow auxFlow : this.outFlows) {
            SequenceFlowImpl flowImpl = InvocationProxy.getUnderlying(auxFlow, SequenceFlowImpl.class);
            if (flowImpl.getOldTransition() != trans) continue;
            outFlow = auxFlow;
            break;
        }
        return outFlow;
    }

    public List<SequenceFlow> getInFlows() {
        return Collections.unmodifiableList(this.inFlows);
    }

    public List<SequenceFlow> getOutFlows() {
        return Collections.unmodifiableList(this.outFlows);
    }
}

