/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class LazyJbpmActionListener
implements JbpmActionListener {
    private final ValueExpression typeExpression;
    private final ValueExpression listenerExpression;

    public LazyJbpmActionListener(ValueExpression typeExpression, ValueExpression listenerExpression) {
        this.typeExpression = typeExpression;
        this.listenerExpression = listenerExpression;
    }

    public String getName() {
        return "jbpmActionListener";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        JbpmActionListener listener;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        if (this.typeExpression != null) {
            Class<?> type;
            Object typeValue = this.typeExpression.getValue(elContext);
            if (typeValue == null) {
                context.setError("Error calling action listener", "The type value is null");
                return;
            }
            if (typeValue instanceof Class) {
                type = (Class<?>)typeValue;
            } else {
                String className = typeValue.toString();
                try {
                    type = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    context.setError("Error calling action listener", "The class '" + className + "' was not found");
                    return;
                }
            }
            if (!JbpmActionListener.class.isAssignableFrom(type)) {
                context.setError("Error calling action listener", "The class '" + type.getName() + "' is not a valid JbpmActionListener");
                return;
            }
            try {
                listener = (JbpmActionListener)type.newInstance();
            }
            catch (Exception e) {
                context.setError("Error calling action listener", e);
                return;
            }
        }
        if (this.listenerExpression != null) {
            Object listenerValue = this.listenerExpression.getValue(elContext);
            if (listenerValue == null) {
                context.setError("Error calling action listener", "The listener value is null");
                return;
            }
            if (!(listenerValue instanceof JbpmActionListener)) {
                context.setError("Error calling action listener", "The listener value given is not a valid JbpmActionListener");
                return;
            }
            listener = (JbpmActionListener)listenerValue;
        } else {
            context.setError("Error calling action listener", "Either a type or a listener must be given");
            return;
        }
        listener.handleAction(context, event);
    }
}

