/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class MoveTokenActionListener
implements JbpmActionListener {
    private final ValueExpression tokenExpression;
    private final ValueExpression nodeExpression;

    public MoveTokenActionListener(ValueExpression tokenExpression, ValueExpression nodeExpression) {
        this.tokenExpression = tokenExpression;
        this.nodeExpression = nodeExpression;
    }

    public String getName() {
        return "moveToken";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            Node node;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object tokenValue = this.tokenExpression.getValue(elContext);
            if (tokenValue == null) {
                context.setError("Error moving token", "The token value is null");
                return;
            }
            if (!(tokenValue instanceof Token)) {
                context.setError("Error moving token", "Attempted to move something other than a token");
                return;
            }
            Token token = (Token)tokenValue;
            Object nodeValue = this.nodeExpression.getValue(elContext);
            if (nodeValue == null) {
                context.setError("Error moving token", "Node value is null");
                return;
            }
            if (nodeValue instanceof Node) {
                node = (Node)nodeValue;
            } else {
                String nodeName = nodeValue.toString();
                node = token.getProcessInstance().getProcessDefinition().getNode(nodeName);
                if (node == null) {
                    context.setError("Error moving token", "No node found by name of '" + nodeName + "'");
                    return;
                }
            }
            token.setNode(node);
            context.addSuccessMessage("Token moved to node '" + node.getName() + "'");
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error moving token", ex);
            return;
        }
    }
}

