/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class RemoveVariableActionListener
implements JbpmActionListener {
    private final ValueExpression nameExpression;
    private final ValueExpression oldValueTargetExpression;
    private final ValueExpression entityExpression;

    public RemoveVariableActionListener(ValueExpression nameExpression, ValueExpression oldValueTargetExpression, ValueExpression entityExpression) {
        this.nameExpression = nameExpression;
        this.oldValueTargetExpression = oldValueTargetExpression;
        this.entityExpression = entityExpression;
    }

    public String getName() {
        return "removeVariable";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            Object oldValue;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object nameValue = this.nameExpression.getValue(elContext);
            if (nameValue == null) {
                context.setError("Error removing variable", "The value of the 'name' attribute is null");
                return;
            }
            String name = nameValue.toString();
            Object entity = this.entityExpression.getValue(elContext);
            if (entity instanceof TaskInstance) {
                TaskInstance task = (TaskInstance)entity;
                oldValue = task.getVariable(name);
                task.deleteVariable(name);
            } else if (entity instanceof Token) {
                Token token = (Token)entity;
                ContextInstance contextInstance = token.getProcessInstance().getContextInstance();
                oldValue = contextInstance.getVariable(name, token);
                contextInstance.deleteVariable(name, token);
            } else if (entity instanceof ProcessInstance) {
                ProcessInstance processInstance = (ProcessInstance)entity;
                ContextInstance contextInstance = processInstance.getContextInstance();
                oldValue = contextInstance.getVariable(name);
                contextInstance.deleteVariable(name);
            } else {
                context.setError("Error removing variable", "The value given for the 'entity' attribute is not a task, token, or process instance");
                return;
            }
            if (this.oldValueTargetExpression != null) {
                this.oldValueTargetExpression.setValue(elContext, oldValue);
            }
            context.addSuccessMessage("Variable '" + name + "' successfully removed");
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error removing variable", ex);
            return;
        }
    }
}

