/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.util.ClassLoaderUtil;

public class ExceptionHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String exceptionClassName;
    protected GraphElement graphElement;
    protected List actions;
    private transient Class exceptionClass;

    public boolean matches(Throwable exception) {
        return this.exceptionClassName != null ? this.getExceptionClass().isInstance(exception) : true;
    }

    private Class getExceptionClass() {
        if (this.exceptionClass == null) {
            try {
                this.exceptionClass = ClassLoaderUtil.classForName(this.exceptionClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JbpmException("exception class not found: " + this.exceptionClassName, e);
            }
        }
        return this.exceptionClass;
    }

    public void handleException(GraphElement graphElement, ExecutionContext executionContext) throws Exception {
        if (this.actions != null) {
            for (Action action : this.actions) {
                graphElement.executeAction(action, executionContext);
            }
        }
    }

    public List getActions() {
        return this.actions;
    }

    public void addAction(Action action) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        this.actions.add(action);
    }

    public void removeAction(Action action) {
        if (this.actions != null) {
            this.actions.remove(action);
        }
    }

    public void reorderAction(int oldIndex, int newIndex) {
        if (this.actions != null) {
            this.actions.add(newIndex, this.actions.remove(oldIndex));
        }
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public GraphElement getGraphElement() {
        return this.graphElement;
    }
}

