/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Collection;
import java.util.Iterator;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class Merge
extends Node {
    private static final long serialVersionUID = 1L;
    boolean isSynchronized = false;

    public Merge() {
    }

    public Merge(String name) {
        super(name);
    }

    public void execute(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        Node mergeNode = token.getNode();
        if (!this.isSynchronized) {
            mergeNode.leave(executionContext);
        } else {
            Collection concurrentTokens = token.getParent().getChildren().values();
            boolean reactivate = true;
            Iterator iter = concurrentTokens.iterator();
            while (iter.hasNext() && reactivate) {
                Token concurrentToken = (Token)iter.next();
                if (mergeNode.equals(concurrentToken.getNode())) continue;
                reactivate = false;
            }
            if (reactivate) {
                for (Token concurrentToken : concurrentTokens) {
                    mergeNode.leave(new ExecutionContext(concurrentToken));
                }
            }
        }
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }
}

