/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.db;

import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.msg.MessageService;

public class DbMessageService
implements MessageService {
    private static final long serialVersionUID = 1L;
    private final JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
    private boolean hasProducedJobs;

    public DbMessageService() {
        if (this.jbpmContext == null) {
            throw new JbpmException("no active jbpm context");
        }
    }

    public void send(Job job) {
        this.jbpmContext.getJobSession().saveJob(job);
        this.hasProducedJobs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.hasProducedJobs) {
            return;
        }
        JobExecutor jobExecutor = this.jbpmContext.getJbpmConfiguration().getJobExecutor();
        if (jobExecutor != null) {
            JobExecutor jobExecutor2 = jobExecutor;
            synchronized (jobExecutor2) {
                jobExecutor.notify();
            }
        }
    }
}

