/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.jbpm.JbpmException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.jta.JtaDbPersistenceServiceFactory;

public class JtaDbPersistenceService
extends DbPersistenceService {
    private UserTransaction userTransaction;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JtaDbPersistenceService.class);

    public JtaDbPersistenceService(JtaDbPersistenceServiceFactory persistenceServiceFactory) {
        super(persistenceServiceFactory);
        if (this.getTransactionStatus() == 6) {
            this.beginTransaction();
        }
    }

    public boolean isTransactionActive() {
        return this.getTransactionStatus() == 0;
    }

    protected boolean isTransactionManagedExternally() {
        return this.userTransaction == null;
    }

    protected boolean isTransactionRollbackOnly() {
        return super.isTransactionRollbackOnly() || this.getTransactionStatus() == 1;
    }

    public void beginTransaction() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"beginning user transaction");
            }
            JtaDbPersistenceServiceFactory jtaFactory = (JtaDbPersistenceServiceFactory)this.persistenceServiceFactory;
            this.userTransaction = jtaFactory.getUserTransaction();
            this.userTransaction.begin();
        }
        catch (NotSupportedException e) {
            throw new JbpmException("transaction already in course", e);
        }
        catch (SystemException e) {
            throw new JbpmException("failed to begin transaction", e);
        }
    }

    private int getTransactionStatus() {
        try {
            if (this.userTransaction != null) {
                return this.userTransaction.getStatus();
            }
            TransactionManager transactionManager = this.getTransactionManager();
            return transactionManager != null ? transactionManager.getStatus() : 6;
        }
        catch (SystemException e) {
            log.error((Object)"could not get transaction status", (Throwable)e);
            return 5;
        }
    }

    private TransactionManager getTransactionManager() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
        return sessionFactory.getSettings().getJtaPlatform().retrieveTransactionManager();
    }

    protected Exception commit() {
        if (this.userTransaction != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"committing user transaction");
            }
            try {
                this.userTransaction.commit();
            }
            catch (RollbackException e) {
                return e;
            }
            catch (HeuristicMixedException e) {
                return e;
            }
            catch (HeuristicRollbackException e) {
                return e;
            }
            catch (SystemException e) {
                return e;
            }
        }
        return null;
    }

    protected Exception rollback() {
        if (this.userTransaction != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"rolling back user transaction");
            }
            try {
                this.userTransaction.rollback();
            }
            catch (SystemException e) {
                return e;
            }
        }
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager == null) {
            throw new JbpmException("cannot honor rollback request without transaction manager");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"marking external transaction for rollback");
        }
        try {
            transactionManager.setRollbackOnly();
        }
        catch (SystemException e) {
            return e;
        }
        return null;
    }

    public boolean isJtaTxCreated() {
        return !this.isTransactionManagedExternally();
    }
}

