/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import org.jbpm.JbpmException;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ConstructorInfo;
import org.jbpm.configuration.FieldInfo;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.PropertyInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class BeanInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    private String className;
    private ConstructorInfo constructorInfo;
    private FieldInfo[] fieldInfos;
    private PropertyInfo[] propertyInfos;

    public BeanInfo() {
    }

    public BeanInfo(Element beanElement, ObjectFactoryParser objectFactoryParser) {
        super(beanElement, objectFactoryParser);
        Element constructorElement = XmlUtil.element(beanElement, "constructor");
        if (constructorElement != null) {
            if (beanElement.hasAttribute("class") && !constructorElement.hasAttribute("class")) {
                constructorElement.setAttribute("class", beanElement.getAttribute("class"));
            }
            this.constructorInfo = new ConstructorInfo(constructorElement, objectFactoryParser);
        } else if (beanElement.hasAttribute("class")) {
            this.className = beanElement.getAttribute("class");
        } else {
            throw new JbpmException("missing class attribute or constructor subelement in bean");
        }
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        Iterator iter = XmlUtil.elementIterator(beanElement, "field");
        while (iter.hasNext()) {
            Element fieldElement = (Element)iter.next();
            fieldInfoList.add(new FieldInfo(fieldElement, objectFactoryParser));
        }
        this.fieldInfos = fieldInfoList.toArray(new FieldInfo[fieldInfoList.size()]);
        ArrayList<PropertyInfo> propertyInfoList = new ArrayList<PropertyInfo>();
        Iterator iter2 = XmlUtil.elementIterator(beanElement, "property");
        while (iter2.hasNext()) {
            Element propertyElement = (Element)iter2.next();
            propertyInfoList.add(new PropertyInfo(propertyElement, objectFactoryParser));
        }
        this.propertyInfos = propertyInfoList.toArray(new PropertyInfo[propertyInfoList.size()]);
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        Object object;
        block12: {
            if (this.constructorInfo == null) {
                if (this.className == null) {
                    throw new JbpmException("bean '" + this.getName() + "' does not specify a class or constructor");
                }
                try {
                    Class clazz = objectFactory.classForName(this.className);
                    try {
                        object = clazz.newInstance();
                        break block12;
                    }
                    catch (InstantiationException e) {
                        throw new JbpmException("failed to instantiate " + clazz, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new JbpmException(this.getClass() + " has no access to " + clazz, e);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new JbpmException("bean '" + this.getName() + "' specifies a missing class", e);
                }
            }
            object = this.constructorInfo.createObject(objectFactory);
        }
        if (this.className == null) {
            this.className = object.getClass().getName();
        }
        if (this.fieldInfos != null) {
            for (int i = 0; i < this.fieldInfos.length; ++i) {
                this.fieldInfos[i].injectProperty(object, objectFactory);
            }
        }
        if (this.propertyInfos != null) {
            for (int i = 0; i < this.propertyInfos.length; ++i) {
                this.propertyInfos[i].injectProperty(object, objectFactory);
            }
        }
        return object;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

