/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.util.ClassLoaderUtil;

public class FieldInstantiator
implements Instantiator {
    private static final Log log = LogFactory.getLog((Class)FieldInstantiator.class);

    public Object instantiate(Class clazz, String configuration) {
        Object newInstance = this.newInstance(clazz);
        if (configuration != null && configuration.length() > 0) {
            Element configurationElement = this.parseConfiguration(configuration);
            Iterator iter = configurationElement.elementIterator();
            while (iter.hasNext()) {
                Element propertyElement = (Element)iter.next();
                String propertyName = propertyElement.getName();
                this.setPropertyValue(clazz, newInstance, propertyName, propertyElement);
            }
        }
        return newInstance;
    }

    protected void setPropertyValue(Class clazz, Object instance, String propertyName, Element propertyElement) {
        Field field = this.findField(clazz, propertyName);
        if (field != null) {
            field.setAccessible(true);
            Object value = FieldInstantiator.getValue(field.getType(), propertyElement);
            try {
                field.set(instance, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("could not set '" + propertyName + "' to: " + value), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)(this.getClass() + " has no access to " + field), (Throwable)e);
            }
        } else {
            log.error((Object)("field not found: " + propertyName));
        }
    }

    private Field findField(Class clazz, String propertyName) {
        while (true) {
            try {
                return clazz.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    protected Element parseConfiguration(String configuration) {
        try {
            return DocumentHelper.parseText((String)("<action>" + configuration + "</action>")).getRootElement();
        }
        catch (DocumentException e) {
            throw new JbpmException("failed to parse configuration", e);
        }
    }

    protected Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new JbpmException("failed to instantiate " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + clazz, e);
        }
    }

    public static Object getValue(Class type, Element propertyElement) {
        Object value = null;
        if (type == String.class) {
            value = propertyElement.getText();
        } else if (type == Integer.class || type == Integer.TYPE) {
            value = new Integer(propertyElement.getTextTrim());
        } else if (type == Long.class || type == Long.TYPE) {
            value = new Long(propertyElement.getTextTrim());
        } else if (type == Float.class || type == Float.TYPE) {
            value = new Float(propertyElement.getTextTrim());
        } else if (type == Double.class || type == Double.TYPE) {
            value = new Double(propertyElement.getTextTrim());
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            value = Boolean.valueOf(propertyElement.getTextTrim());
        } else if (type == Character.class || type == Character.TYPE) {
            value = new Character(propertyElement.getTextTrim().charAt(0));
        } else if (type == Short.class || type == Short.TYPE) {
            value = new Short(propertyElement.getTextTrim());
        } else if (type == Byte.class || type == Byte.TYPE) {
            value = new Byte(propertyElement.getTextTrim());
        } else if (type == List.class || type == Collection.class) {
            value = FieldInstantiator.getCollection(propertyElement, new ArrayList());
        } else if (type == Set.class) {
            value = FieldInstantiator.getCollection(propertyElement, new HashSet());
        } else if (type == SortedSet.class) {
            value = FieldInstantiator.getCollection(propertyElement, new TreeSet());
        } else if (type == Map.class) {
            value = FieldInstantiator.getMap(propertyElement, new HashMap());
        } else if (type == SortedMap.class) {
            value = FieldInstantiator.getMap(propertyElement, new TreeMap());
        } else if (Element.class.isAssignableFrom(type)) {
            value = propertyElement;
        } else {
            try {
                if (Collection.class.isAssignableFrom(type)) {
                    value = FieldInstantiator.getCollection(propertyElement, (Collection)type.newInstance());
                } else if (Map.class.isAssignableFrom(type)) {
                    value = FieldInstantiator.getMap(propertyElement, (Map)type.newInstance());
                } else if (propertyElement.isTextOnly()) {
                    Constructor constructor = type.getConstructor(String.class);
                    try {
                        value = constructor.newInstance(propertyElement.getTextTrim());
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)(FieldInstantiator.class + " has no access to " + constructor));
                    }
                    catch (InvocationTargetException e) {
                        log.error((Object)(constructor + " threw exception"), e.getCause());
                    }
                } else {
                    log.error((Object)("element '" + propertyElement.getName() + "' has non-text content"));
                }
            }
            catch (InstantiationException e) {
                log.error((Object)("failed to instantiate " + type), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)(FieldInstantiator.class + " has no access to " + type), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)("constructor not found: " + type.getName() + "(String)"), (Throwable)e);
            }
        }
        return value;
    }

    private static Map getMap(Element mapElement, Map map) {
        Class keyClass = FieldInstantiator.classForAttributeValue(mapElement, "key-type");
        Class valueClass = FieldInstantiator.classForAttributeValue(mapElement, "value-type");
        Iterator iter = mapElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            Element keyElement = element.element("key");
            Element valueElement = element.element("value");
            map.put(FieldInstantiator.getValue(keyClass, keyElement), FieldInstantiator.getValue(valueClass, valueElement));
        }
        return map;
    }

    private static Object getCollection(Element collectionElement, Collection collection) {
        Class elementClass = FieldInstantiator.classForAttributeValue(collectionElement, "element-type");
        Iterator iter = collectionElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            collection.add(FieldInstantiator.getValue(elementClass, element));
        }
        return collection;
    }

    private static Class classForAttributeValue(Element element, String attributeName) {
        String className = element.attributeValue(attributeName);
        if (className != null) {
            try {
                return ClassLoaderUtil.classForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JbpmException("no such class " + className, e);
            }
        }
        return String.class;
    }
}

