/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job;

import java.io.Serializable;
import java.util.Date;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class Job
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private int version;
    private Date dueDate;
    private ProcessInstance processInstance;
    private Token token;
    private TaskInstance taskInstance;
    private boolean isSuspended;
    private boolean isExclusive;
    private String lockOwner;
    private Date lockTime;
    private String exception;
    private int retries = JbpmConfiguration.Configs.getInt("jbpm.job.retries");
    private String configuration;

    public Job() {
    }

    public Job(Token token) {
        this.token = token;
        this.processInstance = token.getProcessInstance();
    }

    public abstract boolean execute(JbpmContext var1) throws Exception;

    public String toStringLongFormat() {
        return "Job(id=" + this.id + ", version=" + this.version + ", dueDate=" + (this.dueDate != null ? this.dueDate : null) + ", suspended=" + this.isSuspended + ", exclusive=" + this.isExclusive + ", lockOwner=" + this.lockOwner + ", lockTime=" + this.lockTime + ", exception=" + this.exception + ", retries=" + this.retries + ", configuration=" + this.configuration;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public long getId() {
        return this.id;
    }

    public Date getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(Date lockTime) {
        this.lockTime = lockTime;
    }

    public Date getAqcuireDate() {
        return this.lockTime;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public String getJobExecutorName() {
        return this.lockOwner;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    public int getVersion() {
        return this.version;
    }
}

