/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class Timer
extends Job {
    private static final long serialVersionUID = 1L;
    private String name;
    private String repeat;
    private String transitionName;
    private Action action;
    private GraphElement graphElement;
    private String calendarResource;
    private static final Log log = LogFactory.getLog((Class)Timer.class);

    public Timer() {
    }

    public Timer(Token token) {
        super(token);
    }

    public boolean execute(JbpmContext jbpmContext) throws Exception {
        Token token = this.getToken();
        ExecutionContext executionContext = new ExecutionContext(token);
        executionContext.setTimer(this);
        TaskInstance taskInstance = this.getTaskInstance();
        if (taskInstance != null) {
            executionContext.setTaskInstance(taskInstance);
        }
        if (this.graphElement != null) {
            this.graphElement.fireEvent("timer", executionContext);
        }
        if (this.action != null) {
            if (this.graphElement != null) {
                this.graphElement.executeAction(this.action, executionContext);
            } else {
                this.action.execute(executionContext);
            }
        }
        String exception = this.getException();
        if (this.transitionName != null && exception == null) {
            Node node = token.getNode();
            Transition transition = node.getLeavingTransition(this.transitionName);
            if (transition != null) {
                token.signal(transition);
            } else {
                log.warn((Object)(node + " has no leaving transition named " + this.transitionName));
            }
        }
        if (this.repeat != null) {
            BusinessCalendar businessCalendar = this.calendarResource == null ? new BusinessCalendar() : new BusinessCalendar(this.calendarResource);
            Date repeatDate = businessCalendar.add(this.getDueDate(), new Duration(this.repeat));
            if (log.isDebugEnabled()) {
                log.debug((Object)("scheduling " + this + " for repeat on " + repeatDate));
            }
            this.setDueDate(repeatDate);
            this.setLockOwner(null);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer text = new StringBuffer("Timer(");
        if (this.name != null) {
            text.append(this.name);
        } else {
            text.append(this.getId());
        }
        return text.append(')').toString();
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public GraphElement getGraphElement() {
        return this.graphElement;
    }

    public void setGraphElement(GraphElement graphElement) {
        this.graphElement = graphElement;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getCalendarResource() {
        return this.calendarResource;
    }

    public void setCalendarResource(String calendarResource) {
        this.calendarResource = calendarResource;
    }
}

