/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.Job;
import org.jbpm.job.executor.Deactivable;
import org.jbpm.job.executor.DispatcherThread;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.job.executor.LockMonitorThread;

public class JobExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected JbpmConfiguration jbpmConfiguration;
    protected String name;
    protected int nbrOfThreads;
    protected int idleInterval;
    protected int maxIdleInterval;
    private int retryInterval;
    protected int historyMaxSize;
    protected int maxLockTime;
    protected int lockMonitorInterval;
    protected int lockBufferTime;
    private ThreadGroup threadGroup;
    private int waitingExecutorCount;
    private boolean waitingDispatcher;
    private boolean dispatcherActive;
    private Lock waitingExecutorLock = new ReentrantLock();
    private Condition waitingExecutorCondition = this.waitingExecutorLock.newCondition();
    private Condition waitingDispatcherCondition = this.waitingExecutorLock.newCondition();
    private LinkedList dispatchedJobs = new LinkedList();
    protected Map threads;
    protected LockMonitorThread lockMonitorThread;
    protected Map monitoredJobIds = new Hashtable();
    protected boolean isStarted;
    protected static String hostName;
    private static Log log;

    public synchronized void start() {
        if (!this.isStarted) {
            log.info((Object)("starting " + this.name));
            this.activateDispatcher();
            this.threadGroup = new ThreadGroup(this.name){

                public void uncaughtException(Thread thread, Throwable throwable) {
                    if (thread instanceof JobExecutorThread) {
                        JobExecutor.this.startThread(thread.getName());
                    } else if (thread instanceof DispatcherThread) {
                        JobExecutor.this.startDispatcherThread();
                    } else if (thread instanceof LockMonitorThread) {
                        JobExecutor.this.startLockMonitorThread();
                    }
                    super.uncaughtException(thread, throwable);
                }
            };
            for (int i = 1; i <= this.nbrOfThreads; ++i) {
                this.startThread(this.getThreadName(i));
            }
            this.startDispatcherThread();
            this.startLockMonitorThread();
            this.isStarted = true;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("ignoring start: " + this.name + " already started"));
        }
    }

    public synchronized List stop() {
        if (!this.isStarted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ignoring stop, " + this.name + " not started"));
            }
            return Collections.EMPTY_LIST;
        }
        log.info((Object)("stopping " + this.name));
        this.isStarted = false;
        Thread[] activeThreads = new Thread[this.nbrOfThreads + 2];
        int activeCount = this.threadGroup.enumerate(activeThreads, false);
        ArrayList<Thread> deactivatedThreads = new ArrayList<Thread>(activeCount);
        for (int i = 0; i < activeCount; ++i) {
            Thread thread = activeThreads[i];
            if (!(thread instanceof Deactivable)) continue;
            Deactivable deactivable = (Deactivable)((Object)thread);
            deactivable.deactivate();
            deactivatedThreads.add(thread);
        }
        this.deactivateDispatcher();
        return deactivatedThreads;
    }

    public void stopAndJoin() throws InterruptedException {
        List threads = this.stop();
        Iterator i = threads.iterator();
        while (i.hasNext()) {
            Thread thread = (Thread)i.next();
            thread.join();
        }
    }

    public void ensureThreadsAreActive() {
        Map threads = this.getThreads();
        for (int i = 1; i <= this.nbrOfThreads; ++i) {
            String threadName = this.getThreadName(i);
            if (threads.containsKey(threadName)) continue;
            this.startThread(threadName);
        }
        if (!threads.containsKey(this.getDispatcherThreadName())) {
            this.startDispatcherThread();
        }
        if (!threads.containsKey(this.getLockMonitorThreadName())) {
            this.startLockMonitorThread();
        }
    }

    ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    private String getThreadName(int index) {
        return this.name + '@' + JobExecutor.getHostAddress() + ":Executor-" + index;
    }

    protected void startThread() {
        this.startThread(this.getNextThreadName());
    }

    protected void startThread(String threadName) {
        Thread thread = this.createThread(threadName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting " + threadName));
        }
        thread.start();
    }

    protected Thread createThread(String threadName) {
        return new JobExecutorThread(threadName, this);
    }

    protected String getNextThreadName() {
        return this.getThreadName(this.threadGroup.activeCount() + 1);
    }

    protected String getLastThreadName() {
        Map threads = this.getThreads();
        for (int i = this.nbrOfThreads; i > 0; --i) {
            String threadName = this.getThreadName(i);
            if (!threads.containsKey(threadName)) continue;
            return threadName;
        }
        return null;
    }

    protected synchronized Thread stopThread() {
        Map threads = this.getThreads();
        for (int i = this.nbrOfThreads; i > 0; --i) {
            String threadName = this.getThreadName(i);
            JobExecutorThread executorThread = (JobExecutorThread)threads.get(threadName);
            if (executorThread == null) continue;
            executorThread.deactivate();
            return executorThread;
        }
        return null;
    }

    private String getDispatcherThreadName() {
        return this.name + '@' + JobExecutor.getHostAddress() + ':' + "Dispatcher";
    }

    void startDispatcherThread() {
        String threadName = this.getDispatcherThreadName();
        DispatcherThread dispatcherThread = new DispatcherThread(threadName, this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting " + threadName));
        }
        dispatcherThread.start();
    }

    private String getLockMonitorThreadName() {
        return this.name + '@' + JobExecutor.getHostAddress() + ':' + "Monitor";
    }

    void startLockMonitorThread() {
        String threadName = this.getLockMonitorThreadName();
        LockMonitorThread lockMonitorThread = new LockMonitorThread(threadName, this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting " + threadName));
        }
        lockMonitorThread.start();
    }

    private static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public Set getMonitoredJobIds() {
        return new HashSet(this.monitoredJobIds.values());
    }

    public void addMonitoredJobId(String threadName, long jobId) {
        this.monitoredJobIds.put(threadName, new Long(jobId));
    }

    public void removeMonitoredJobId(String threadName) {
        this.monitoredJobIds.remove(threadName);
    }

    public void setMonitoredJobIds(Map monitoredJobIds) {
    }

    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historyMaxSize = historyMaxSize;
    }

    public int getIdleInterval() {
        return this.idleInterval;
    }

    public void setIdleInterval(int idleInterval) {
        if (idleInterval <= 0) {
            throw new IllegalArgumentException("idle interval must be positive");
        }
        this.idleInterval = idleInterval;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        if (retryInterval <= 0) {
            throw new IllegalArgumentException("retry interval must be positive");
        }
        this.retryInterval = retryInterval;
    }

    public int getMaxIdleInterval() {
        return this.maxIdleInterval;
    }

    public void setMaxIdleInterval(int maxIdleInterval) {
        if (maxIdleInterval <= 0) {
            throw new IllegalArgumentException("max idle interval must be positive");
        }
        this.maxIdleInterval = maxIdleInterval;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.nbrOfThreads;
    }

    public void setSize(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    public Map getThreads() {
        Thread[] activeThreads = new Thread[this.nbrOfThreads + 2];
        int activeCount = this.threadGroup.enumerate(activeThreads, false);
        HashMap<String, Thread> threadMap = new HashMap<String, Thread>(activeCount);
        for (int i = 0; i < activeCount; ++i) {
            Thread thread = activeThreads[i];
            threadMap.put(thread.getName(), thread);
        }
        return threadMap;
    }

    public void setThreads(Map threads) {
    }

    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    public void setMaxLockTime(int maxLockTime) {
        if (maxLockTime <= 0) {
            throw new IllegalArgumentException("max lock time must be positive");
        }
        this.maxLockTime = maxLockTime;
    }

    public int getLockBufferTime() {
        return this.lockBufferTime;
    }

    public void setLockBufferTime(int lockBufferTime) {
        this.lockBufferTime = lockBufferTime;
    }

    public int getLockMonitorInterval() {
        return this.lockMonitorInterval;
    }

    public void setLockMonitorInterval(int lockMonitorInterval) {
        if (lockMonitorInterval <= 0) {
            throw new IllegalArgumentException("lock monitor interval must be positive");
        }
        this.lockMonitorInterval = lockMonitorInterval;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public void setNbrOfThreads(int nbrOfThreads) {
        if (nbrOfThreads <= 0) {
            throw new IllegalArgumentException("number of threads must be positive");
        }
        this.nbrOfThreads = nbrOfThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFreeExecutor() {
        this.waitingExecutorLock.lock();
        try {
            boolean bl = this.waitingExecutorCount > this.dispatchedJobs.size();
            return bl;
        }
        finally {
            this.waitingExecutorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFreeExecutorThread() {
        this.waitingExecutorLock.lock();
        try {
            this.waitingDispatcher = true;
            if (this.dispatcherActive) {
                if (this.hasFreeExecutor()) {
                    boolean bl = true;
                    return bl;
                }
                this.waitingDispatcherCondition.await();
                boolean bl = this.hasFreeExecutor();
                return bl;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.waitingDispatcher = false;
            this.waitingExecutorLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Job getJob() {
        this.waitingExecutorLock.lock();
        try {
            ++this.waitingExecutorCount;
            if (this.dispatcherActive) {
                if (this.waitingDispatcher && this.hasFreeExecutor()) {
                    this.waitingDispatcherCondition.signal();
                }
                if (this.dispatchedJobs.isEmpty()) {
                    this.waitingExecutorCondition.await();
                }
                if (this.dispatchedJobs.size() > 0) {
                    Job job = (Job)this.dispatchedJobs.remove(0);
                    return job;
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            --this.waitingExecutorCount;
            this.waitingExecutorLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean submitJob(Job job) {
        this.waitingExecutorLock.lock();
        try {
            if (this.hasFreeExecutor()) {
                this.dispatchedJobs.add(job);
                this.waitingExecutorCondition.signal();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.waitingExecutorLock.unlock();
        }
        return false;
    }

    private void activateDispatcher() {
        this.waitingExecutorLock.lock();
        this.dispatcherActive = true;
        this.waitingExecutorLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateDispatcher() {
        this.waitingExecutorLock.lock();
        try {
            this.dispatcherActive = false;
            this.waitingDispatcherCondition.signal();
            this.waitingExecutorCondition.signalAll();
        }
        finally {
            this.waitingExecutorLock.unlock();
        }
    }

    static {
        log = LogFactory.getLog((Class)JobExecutor.class);
    }
}

