/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.svc.save;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.svc.save.SaveOperation;

public class CascadeSaveOperation
implements SaveOperation {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((Class)CascadeSaveOperation.class);

    public void save(ProcessInstance processInstance, JbpmContext jbpmContext) {
        HashSet<ProcessInstance> cascadedProcessInstances = new HashSet<ProcessInstance>();
        cascadedProcessInstances.add(processInstance);
        this.cascadeSave(processInstance.removeCascadeProcessInstances(), jbpmContext, cascadedProcessInstances);
    }

    private void cascadeSave(Collection cascadeProcessInstances, JbpmContext jbpmContext, Set cascadedProcessInstances) {
        if (cascadeProcessInstances != null) {
            Iterator iter = cascadeProcessInstances.iterator();
            while (iter.hasNext()) {
                ProcessInstance cascadeInstance = (ProcessInstance)iter.next();
                this.saveCascadeInstance(cascadeInstance, jbpmContext, cascadedProcessInstances);
            }
        }
    }

    private void saveCascadeInstance(ProcessInstance cascadeInstance, JbpmContext jbpmContext, Set cascadedProcessInstances) {
        if (!cascadedProcessInstances.contains(cascadeInstance)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cascading save to " + cascadeInstance));
            }
            jbpmContext.save(cascadeInstance);
            cascadedProcessInstances.add(cascadeInstance);
            Collection cascadeProcessInstances = cascadeInstance.removeCascadeProcessInstances();
            this.cascadeSave(cascadeProcessInstances, jbpmContext, cascadedProcessInstances);
        }
    }
}

